/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.MuleManifest;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.i18n.HttpMessages;

public class MuleMessageToHttpResponse
extends AbstractMessageTransformer {
    public static final String CUSTOM_HEADER_PREFIX = "";
    private String server;

    public MuleMessageToHttpResponse() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.create(HttpResponse.class));
    }

    public void initialise() throws InitialisationException {
        this.server = MuleManifest.getProductName() == null ? "Mule/SNAPSHOT" : MuleManifest.getProductName() + "/" + MuleManifest.getProductVersion();
    }

    public Object transformMessage(MuleMessage msg, String outputEncoding) throws TransformerException {
        Object src = msg.getPayload();
        if (src instanceof NullPayload) {
            src = CUSTOM_HEADER_PREFIX;
        }
        try {
            String method;
            String connHeader;
            HttpResponse response = src instanceof HttpResponse ? (HttpResponse)src : this.createResponse(src, outputEncoding, msg);
            if (!response.containsHeader("Content-Type")) {
                response.addHeader(new Header("Content-Type", "text/plain"));
            }
            if (!response.containsHeader("Content-Length") && !response.containsHeader("Transfer-Encoding")) {
                if (response.hasBody()) {
                    long len = response.getContentLength();
                    if (len < 0L) {
                        if (response.getHttpVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                            len = msg.getPayloadAsBytes().length;
                            response.setBody(msg);
                            Header header = new Header("Content-Length", Long.toString(len));
                            response.setHeader(header);
                        } else {
                            Header header = new Header("Transfer-Encoding", "chunked");
                            response.addHeader(header);
                        }
                    } else {
                        Header header = new Header("Content-Length", Long.toString(len));
                        response.setHeader(header);
                    }
                } else {
                    Header header = new Header("Content-Length", "0");
                    response.addHeader(header);
                }
            }
            if ((connHeader = (String)msg.getOutboundProperty("Connection")) != null) {
                if (connHeader.equalsIgnoreCase("keep-alive")) {
                    response.setKeepAlive(true);
                }
                if (connHeader.equalsIgnoreCase("close")) {
                    response.setKeepAlive(false);
                }
            }
            if ("HEAD".equalsIgnoreCase(method = (String)msg.getOutboundProperty("http.method"))) {
                response.setBody((MuleMessage)null);
            }
            return response;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected HttpResponse createResponse(Object src, String encoding, MuleMessage msg) throws IOException, TransformerException {
        String etag;
        HttpResponse response = new HttpResponse();
        Object tmp = msg.getOutboundProperty("http.status");
        int status = 200;
        if (tmp != null) {
            status = Integer.valueOf(tmp.toString());
        } else if (msg.getExceptionPayload() != null) {
            status = 500;
        }
        String version = (String)msg.getInboundProperty("http.version");
        if (version == null) {
            version = "HTTP/1.1";
        }
        String date = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US).format(new Date());
        String contentType = (String)msg.getInboundProperty("Content-Type");
        if (contentType == null) {
            contentType = (String)msg.getInvocationProperty("Content-Type");
        }
        response.setStatusLine(HttpVersion.parse((String)version), status);
        if (contentType != null) {
            response.setHeader(new Header("Content-Type", contentType));
        }
        response.setHeader(new Header("Date", date));
        response.setHeader(new Header("Server", this.server));
        if (msg.getOutboundProperty("Expires") == null) {
            response.setHeader(new Header("Expires", date));
        }
        if ((etag = (String)msg.getOutboundProperty("ETag")) != null) {
            response.setHeader(new Header("ETag", etag));
        }
        response.setFallbackCharset(encoding);
        Collection<String> headerNames = HttpConstants.RESPONSE_HEADER_NAMES.values();
        for (String headerName : headerNames) {
            if ("Set-Cookie".equals(headerName)) {
                Cookie[] arrayOfCookies;
                Object cookiesObject = msg.getInvocationProperty(headerName);
                if (cookiesObject == null) {
                    cookiesObject = msg.getOutboundProperty(headerName);
                }
                if (cookiesObject == null) {
                    cookiesObject = msg.getInboundProperty(headerName);
                }
                if (cookiesObject == null) continue;
                if (!(cookiesObject instanceof Cookie[])) {
                    response.addHeader(new Header(headerName, cookiesObject.toString()));
                    continue;
                }
                for (Cookie cookie : arrayOfCookies = CookieHelper.asArrayOfCookies(cookiesObject)) {
                    response.addHeader(new Header(headerName, CookieHelper.formatCookieForASetCookieHeader(cookie)));
                }
                continue;
            }
            String value = (String)msg.getInvocationProperty(headerName);
            if (value == null) {
                value = (String)msg.getOutboundProperty(headerName);
            }
            if (value == null) continue;
            response.setHeader(new Header(headerName, value));
        }
        Map customHeaders = (Map)msg.getOutboundProperty("http.custom.headers");
        if (customHeaders != null) {
            throw new TransformerException(HttpMessages.customHeaderMapDeprecated(), (Transformer)this);
        }
        for (String headerName : msg.getOutboundPropertyNames()) {
            Object v = msg.getOutboundProperty(headerName);
            if (v == null) continue;
            response.setHeader(new Header(headerName, v.toString()));
        }
        String user = (String)msg.getOutboundProperty("MULE_USER");
        if (user != null) {
            response.setHeader(new Header("MULE_USER", user));
        }
        if (msg.getCorrelationId() != null) {
            response.setHeader(new Header("MULE_CORRELATION_ID", msg.getCorrelationId()));
            response.setHeader(new Header("MULE_CORRELATION_GROUP_SIZE", String.valueOf(msg.getCorrelationGroupSize())));
            response.setHeader(new Header("MULE_CORRELATION_SEQUENCE", String.valueOf(msg.getCorrelationSequence())));
        }
        if (msg.getReplyTo() != null) {
            response.setHeader(new Header("MULE_REPLYTO", msg.getReplyTo().toString()));
        }
        try {
            response.setBody(msg);
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return response;
    }

    public boolean isAcceptNull() {
        return true;
    }
}

