/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;

public class DefaultMessageCollection
extends DefaultMuleMessage
implements MuleMessageCollection {
    private List messageList = new CopyOnWriteArrayList();

    public DefaultMessageCollection(MuleContext muleContext) {
        super(new CopyOnWriteArrayList(), muleContext);
    }

    public DefaultMessageCollection(DefaultMessageCollection msg, MuleContext muleContext) {
        this(muleContext);
        for (int i = 0; i < msg.getMessagesAsArray().length; ++i) {
            this.addMessage(msg.getMessagesAsArray()[i]);
        }
    }

    @Override
    public void addMessage(MuleMessage message) {
        this.getMessageList().add(message);
        this.getPayloadList().add(message.getPayload());
    }

    @Override
    public MuleMessage[] getMessagesAsArray() {
        List list = this.getMessageList();
        MuleMessage[] messages = new MuleMessage[list.size()];
        messages = list.toArray(messages);
        return messages;
    }

    @Override
    public Object[] getPayloadsAsArray() {
        List list = this.getPayloadList();
        Object[] payloads = new Object[list.size()];
        payloads = list.toArray(payloads);
        return payloads;
    }

    @Override
    public void removedMessage(MuleMessage message) {
        this.getMessageList().remove(message);
        this.getPayloadList().remove(message.getPayload());
    }

    @Override
    public void addMessage(MuleMessage message, int index) {
        this.getMessageList().add(index, message);
        this.getPayloadList().add(index, message.getPayload());
    }

    @Override
    public void addMessages(MuleEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            MuleEvent event = events[i];
            this.addMessage(event.getMessage());
        }
    }

    @Override
    public void addMessages(List messages) {
        for (MuleMessage message : messages) {
            this.addMessage(message);
        }
    }

    @Override
    public void addMessages(MuleMessage[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            this.addMessage(messages[i]);
        }
    }

    @Override
    public MuleMessage getMessage(int index) {
        return (MuleMessage)this.getMessageList().get(index);
    }

    protected List getMessageList() {
        return this.messageList;
    }

    protected List getPayloadList() {
        return (List)this.getPayload();
    }

    public Object getPayload(Class outputType) throws TransformerException {
        DataType outputDataType = DataTypeFactory.create(outputType);
        ArrayList results = new ArrayList(this.getMessageList().size());
        for (MuleMessage message : this.getMessageList()) {
            results.add(message.getPayload(outputDataType));
        }
        return results;
    }

    @Override
    public int size() {
        return this.getMessageList().size();
    }

    @Override
    public byte[] getPayloadAsBytes() throws Exception {
        throw new UnsupportedOperationException("getPayloadAsBytes(), use getPayload(DataType.BYTE_ARRAY_DATA_TYPE)");
    }

    @Override
    public String getPayloadAsString(String encoding) throws Exception {
        throw new UnsupportedOperationException("getPayloadAsString(), use getPayload(DataType.STRING_DATA_TYPE)");
    }

    @Override
    public String getPayloadForLogging(String encoding) {
        return "[This is a message collection]";
    }

    @Override
    public String getPayloadForLogging() {
        return "[This is a message collection]";
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        return new DefaultMessageCollection(this, this.muleContext);
    }

    @Override
    public MuleMessage createInboundMessage() throws Exception {
        MuleMessage[] messages;
        DefaultMessageCollection newMessage = new DefaultMessageCollection(this.getMuleContext());
        for (MuleMessage message : messages = this.getMessagesAsArray()) {
            newMessage.addMessage(message.createInboundMessage());
        }
        return newMessage;
    }
}

