/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.endpoint.AbstractEndpointBuilder;
import org.mule.endpoint.DynamicURIOutboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.endpoint.URIBuilder;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;

public class DynamicOutboundEndpoint
extends DynamicURIOutboundEndpoint {
    public static final String DYNAMIC_URI_PLACEHOLDER = "dynamic://endpoint";
    protected final transient Log logger = LogFactory.getLog(DynamicOutboundEndpoint.class);
    private static final long serialVersionUID = 8861985949279708638L;
    protected String uriTemplate;
    private final EndpointBuilder builder;

    public DynamicOutboundEndpoint(MuleContext muleContext, EndpointBuilder builder, String uriTemplate) throws MalformedEndpointException {
        super(new NullOutboundEndpoint(muleContext, builder));
        this.builder = builder;
        this.uriTemplate = uriTemplate;
        this.validateUriTemplate(uriTemplate);
    }

    @Override
    public String getAddress() {
        EndpointURI uri = this.getEndpointURI();
        if (uri != null) {
            return uri.getUri().toString();
        }
        return this.uriTemplate;
    }

    protected void validateUriTemplate(String uri) throws MalformedEndpointException {
        if (uri.indexOf(":") > uri.indexOf("#[")) {
            throw new MalformedEndpointException(CoreMessages.dynamicEndpointsMustSpecifyAScheme(), uri);
        }
    }

    protected EndpointURI getEndpointURIForMessage(MuleEvent event) throws DispatchException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + this.uriTemplate));
        }
        String newUriString = this.uriTemplate;
        try {
            newUriString = this.parseURIString(newUriString, event.getMessage());
        }
        catch (ExpressionRuntimeException e) {
            throw new DispatchException(event, this, (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + newUriString));
        }
        try {
            MuleEndpointURI uri = new MuleEndpointURI(newUriString, this.getMuleContext());
            uri.initialise();
            this.setEndpointURI(uri);
            return this.getEndpointURI();
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.templateCausedMalformedEndpoint(this.uriTemplate, newUriString), event, this, e);
        }
    }

    protected String parseURIString(String uri, MuleMessage message) {
        return this.getMuleContext().getExpressionManager().parse(uri, message, true);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        EndpointURI uri = this.getEndpointURIForMessage(event);
        this.builder.setURIBuilder(new URIBuilder(uri));
        this.endpoint = this.builder.buildOutboundEndpoint();
        DynamicURIOutboundEndpoint outboundEndpoint = new DynamicURIOutboundEndpoint(this.endpoint, uri);
        return outboundEndpoint.process(event);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    protected static class NullOutboundEndpoint
    extends AbstractEndpoint
    implements OutboundEndpoint {
        private static final long serialVersionUID = 7927987219248986540L;

        NullOutboundEndpoint(MuleContext muleContext, EndpointBuilder builder) {
            super(NullOutboundEndpoint.createDynamicConnector(muleContext), null, null, Collections.emptyMap(), null, true, NullOutboundEndpoint.getMessageExchangePattern(builder), 0, "started", null, null, muleContext, null, null, null, null, true, null);
        }

        @Override
        protected MessageProcessor createMessageProcessorChain(FlowConstruct flowConstruct) throws MuleException {
            throw new UnsupportedOperationException("createMessageProcessorChain");
        }

        @Override
        public List<String> getResponseProperties() {
            return Collections.emptyList();
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            throw new UnsupportedOperationException("process");
        }

        static Connector createDynamicConnector(MuleContext muleContext) {
            try {
                return new TransportFactory(muleContext).createConnector(DynamicOutboundEndpoint.DYNAMIC_URI_PLACEHOLDER);
            }
            catch (TransportFactoryException e) {
                throw new MuleRuntimeException(e);
            }
        }

        static MessageExchangePattern getMessageExchangePattern(EndpointBuilder builder) {
            if (!(builder instanceof AbstractEndpointBuilder)) {
                return MessageExchangePattern.ONE_WAY;
            }
            return ((AbstractEndpointBuilder)builder).messageExchangePattern;
        }
    }
}

