/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.MessageFactory;
import org.mule.routing.CorrelationMode;
import org.mule.routing.outbound.FilteringOutboundRouter;

public abstract class AbstractRecipientList
extends FilteringOutboundRouter {
    private final ConcurrentMap<Object, OutboundEndpoint> recipientCache = new ConcurrentHashMap<Object, OutboundEndpoint>();
    private Boolean synchronous;

    @Override
    public MuleEvent route(MuleEvent event) throws RoutingException {
        MuleMessage message = event.getMessage();
        List<Object> recipients = this.getRecipients(event);
        ArrayList<MuleEvent> results = new ArrayList<MuleEvent>();
        if (this.enableCorrelation != CorrelationMode.NEVER) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationGroupSize() != -1;
            if (correlationSet && this.enableCorrelation == CorrelationMode.IF_NOT_SET) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(recipients.size());
            }
        }
        OutboundEndpoint endpoint = null;
        for (Object recipient : recipients) {
            DefaultMuleMessage request = new DefaultMuleMessage(message.getPayload(), message, this.muleContext);
            try {
                boolean sync;
                endpoint = this.getRecipientEndpoint(request, recipient);
                boolean bl = sync = this.synchronous == null ? endpoint.getExchangePattern().hasResponse() : this.synchronous.booleanValue();
                if (sync) {
                    results.add(this.sendRequest(event, request, endpoint, true));
                    continue;
                }
                this.sendRequest(event, request, endpoint, false);
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(event, endpoint, (Throwable)e);
            }
        }
        return this.resultsHandler.aggregateResults(results, event, this.muleContext);
    }

    protected OutboundEndpoint getRecipientEndpoint(MuleMessage message, Object recipient) throws MuleException {
        OutboundEndpoint endpoint = null;
        if (recipient instanceof OutboundEndpoint) {
            endpoint = (OutboundEndpoint)recipient;
        } else if (recipient instanceof EndpointURI) {
            endpoint = this.getRecipientEndpointFromUri((EndpointURI)recipient);
        } else if (recipient instanceof String) {
            endpoint = this.getRecipientEndpointFromString(message, (String)recipient);
        }
        if (null == endpoint) {
            throw new RegistrationException(MessageFactory.createStaticMessage("Failed to create endpoint for: " + recipient));
        }
        OutboundEndpoint existingEndpoint = this.recipientCache.putIfAbsent(recipient, endpoint);
        if (existingEndpoint != null) {
            endpoint = existingEndpoint;
        }
        return endpoint;
    }

    protected OutboundEndpoint getRecipientEndpointFromUri(EndpointURI uri) throws MuleException {
        OutboundEndpoint endpoint = null;
        if (null != this.getMuleContext() && null != this.getMuleContext().getRegistry()) {
            endpoint = this.getMuleContext().getEndpointFactory().getOutboundEndpoint(uri.getAddress());
        }
        if (null != endpoint) {
            this.muleContext.getRegistry().applyLifecycle(endpoint);
        }
        return endpoint;
    }

    protected OutboundEndpoint getRecipientEndpointFromString(MuleMessage message, String recipient) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.recipientCache.get(recipient);
        if (null == endpoint && null != this.getMuleContext() && null != this.getMuleContext().getRegistry()) {
            endpoint = this.getMuleContext().getEndpointFactory().getOutboundEndpoint(recipient);
        }
        return endpoint;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    @Override
    public boolean isDynamicRoutes() {
        return true;
    }

    protected abstract List<Object> getRecipients(MuleEvent var1) throws CouldNotRouteOutboundMessageException;
}

