/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.CaseInsensitiveHashMap;

public final class TemplateParser {
    public static final String ANT_TEMPLATE_STYLE = "ant";
    public static final String SQUARE_TEMPLATE_STYLE = "square";
    public static final String CURLY_TEMPLATE_STYLE = "curly";
    public static final String WIGGLY_MULE_TEMPLATE_STYLE = "mule";
    private static final String DOLLAR_ESCAPE = "@@@";
    private static final Map<String, PatternInfo> patterns = new HashMap<String, PatternInfo>();
    protected static final Log logger;
    public static final Pattern ANT_TEMPLATE_PATTERN;
    public static final Pattern SQUARE_TEMPLATE_PATTERN;
    public static final Pattern CURLY_TEMPLATE_PATTERN;
    public static final Pattern WIGGLY_MULE_TEMPLATE_PATTERN;
    private final Pattern pattern;
    private final int pre;
    private final int post;
    private final PatternInfo style;

    public static TemplateParser createAntStyleParser() {
        return new TemplateParser(ANT_TEMPLATE_STYLE);
    }

    public static TemplateParser createSquareBracesStyleParser() {
        return new TemplateParser(SQUARE_TEMPLATE_STYLE);
    }

    public static TemplateParser createCurlyBracesStyleParser() {
        return new TemplateParser(CURLY_TEMPLATE_STYLE);
    }

    public static TemplateParser createMuleStyleParser() {
        return new TemplateParser(WIGGLY_MULE_TEMPLATE_STYLE);
    }

    private TemplateParser(String styleName) {
        this.style = patterns.get(styleName);
        if (this.style == null) {
            throw new IllegalArgumentException("Unknown template style: " + styleName);
        }
        this.pattern = this.style.getPattern();
        this.pre = this.style.getPrefix().length();
        this.post = this.style.getSuffix().length();
    }

    public String parse(Map props, String template) {
        return this.parse(props, template, null);
    }

    public String parse(TemplateCallback callback, String template) {
        return this.parse(null, template, callback);
    }

    protected String parse(Map props, String template, TemplateCallback callback) {
        String result = template;
        Object newProps = props;
        if (props != null && !(props instanceof CaseInsensitiveHashMap)) {
            newProps = new CaseInsensitiveHashMap(props);
        }
        Matcher m = this.pattern.matcher(result);
        while (m.find()) {
            Object value = null;
            String match = m.group();
            String propname = match.substring(this.pre, match.length() - this.post);
            if (callback != null) {
                value = callback.match(propname);
            } else if (newProps != null) {
                value = newProps.get(propname);
            }
            if (value == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Value " + propname + " not found in context"));
                continue;
            }
            String matchRegex = this.escape(match);
            String valueString = value.toString();
            if (valueString.indexOf(36) != -1) {
                valueString = valueString.replaceAll("\\$", DOLLAR_ESCAPE);
            }
            if (valueString.indexOf(92) != -1) {
                valueString = valueString.replaceAll("\\\\", "\\\\\\\\");
            }
            result = result.replaceAll(matchRegex, valueString);
        }
        if (result.indexOf(DOLLAR_ESCAPE) != -1) {
            result = result.replaceAll(DOLLAR_ESCAPE, "\\$");
        }
        return result;
    }

    public List parse(Map props, List templates) {
        if (templates == null) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>(templates.size());
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            list.add(this.parse(props, iterator.next().toString()));
        }
        return list;
    }

    public Map parse(final Map props, Map templates) {
        return this.parse(new TemplateCallback(){

            @Override
            public Object match(String token) {
                return props.get(token);
            }
        }, templates);
    }

    public Map parse(TemplateCallback callback, Map templates) {
        if (templates == null) {
            return new HashMap();
        }
        HashMap map = new HashMap(templates.size());
        for (Map.Entry entry : templates.entrySet()) {
            map.put(entry.getKey(), this.parse(callback, entry.getValue().toString()));
        }
        return map;
    }

    private String escape(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char currentCharacter = string.charAt(i);
            switch (currentCharacter) {
                case '#': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    buffer.append("\\");
                }
            }
            buffer.append(currentCharacter);
        }
        return buffer.toString();
    }

    public PatternInfo getStyle() {
        return this.style;
    }

    public boolean isContainsTemplate(String value) {
        if (value == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(value);
        return m.find();
    }

    public boolean isValid(String expression) {
        try {
            this.style.validate(expression);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void validate(String expression) throws IllegalArgumentException {
        this.style.validate(expression);
    }

    static {
        patterns.put(ANT_TEMPLATE_STYLE, new PatternInfo(ANT_TEMPLATE_STYLE, "\\$\\{[^\\}]+\\}", "${", "}"));
        patterns.put(SQUARE_TEMPLATE_STYLE, new PatternInfo(SQUARE_TEMPLATE_STYLE, "\\[[^\\]]+\\]", "[", "]"));
        patterns.put(CURLY_TEMPLATE_STYLE, new PatternInfo(CURLY_TEMPLATE_STYLE, "\\{[^\\}]+\\}", "{", "}"));
        patterns.put(WIGGLY_MULE_TEMPLATE_STYLE, new PatternInfo(WIGGLY_MULE_TEMPLATE_STYLE, "#\\[((?:#\\[(?:#\\[.*?\\]|\\[.*?\\]|.)*?\\]|\\[.*?\\]|.)*?)\\]", "#[", "]"));
        logger = LogFactory.getLog(TemplateParser.class);
        ANT_TEMPLATE_PATTERN = patterns.get(ANT_TEMPLATE_STYLE).getPattern();
        SQUARE_TEMPLATE_PATTERN = patterns.get(SQUARE_TEMPLATE_STYLE).getPattern();
        CURLY_TEMPLATE_PATTERN = patterns.get(CURLY_TEMPLATE_STYLE).getPattern();
        WIGGLY_MULE_TEMPLATE_PATTERN = patterns.get(WIGGLY_MULE_TEMPLATE_STYLE).getPattern();
    }

    public static class PatternInfo {
        String name;
        String regEx;
        String prefix;
        String suffix;

        PatternInfo(String name, String regEx, String prefix, String suffix) {
            this.name = name;
            this.regEx = regEx;
            if (prefix.length() < 1 || prefix.length() > 2) {
                throw new IllegalArgumentException("Prefix can only be one or two characters long: " + prefix);
            }
            this.prefix = prefix;
            if (suffix.length() != 1) {
                throw new IllegalArgumentException("Suffic can only be one character long: " + suffix);
            }
            this.suffix = suffix;
        }

        public String getRegEx() {
            return this.regEx;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getName() {
            return this.name;
        }

        public Pattern getPattern() {
            return Pattern.compile(this.regEx, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void validate(String expression) throws IllegalArgumentException {
            char open;
            Stack<Character> openDelimiterStack = new Stack<Character>();
            int charCount = expression.length();
            int index = 0;
            char nextChar = ' ';
            char preDelim = '\u0000';
            boolean inExpression = false;
            int expressionCount = 0;
            if (this.prefix.length() == 2) {
                preDelim = this.prefix.charAt(0);
                open = this.prefix.charAt(1);
            } else {
                open = this.prefix.charAt(0);
            }
            char close = this.suffix.charAt(0);
            while (index < charCount) {
                nextChar = expression.charAt(index);
                if (preDelim != '\u0000' && nextChar == preDelim) {
                    if (inExpression) {
                        if (index < charCount && expression.charAt(index + 1) == open) {
                            throw new IllegalArgumentException(String.format("Character %s at position %s suggests an expression inside an expression", Character.valueOf(open), index));
                        }
                    } else {
                        if (!openDelimiterStack.isEmpty()) throw new IllegalArgumentException(String.format("Character %s at position %s appears out of sequence. Character cannot appear after %s", Character.valueOf(nextChar), index, openDelimiterStack.pop()));
                        openDelimiterStack.push(Character.valueOf(nextChar));
                        nextChar = expression.charAt(++index);
                        if (nextChar != open) {
                            throw new IllegalArgumentException(String.format("Character %s at position %s must appear immediately after %s", Character.valueOf(open), index, Character.valueOf(preDelim)));
                        }
                        inExpression = true;
                    }
                }
                if (nextChar == open) {
                    if (preDelim == '\u0000' || inExpression) {
                        openDelimiterStack.push(Character.valueOf(nextChar));
                    } else {
                        if (openDelimiterStack.size() != 1 || !((Character)openDelimiterStack.peek()).equals(Character.valueOf(preDelim))) throw new IllegalArgumentException(String.format("Character %s at position %s appears out of sequence. Character cannot appear after %s", Character.valueOf(nextChar), index, Character.valueOf(preDelim)));
                        openDelimiterStack.push(Character.valueOf(nextChar));
                    }
                } else if (nextChar == close) {
                    if (openDelimiterStack.isEmpty()) {
                        throw new IllegalArgumentException(String.format("Character %s at position %s appears out of sequence", Character.valueOf(nextChar), index));
                    }
                    openDelimiterStack.pop();
                    if (preDelim != '\u0000' && ((Character)openDelimiterStack.peek()).charValue() == preDelim) {
                        openDelimiterStack.pop();
                    }
                    if (openDelimiterStack.isEmpty()) {
                        inExpression = false;
                        ++expressionCount;
                    }
                }
                ++index;
            }
            if (expressionCount != 0) return;
            throw new IllegalArgumentException("Not an expression: " + expression);
        }
    }

    public static interface TemplateCallback {
        public Object match(String var1);
    }
}

