/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.migration.InstanceMigrator;
import org.jbpm.pvm.internal.migration.MigrationDescriptor;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.repository.Deployer;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;

public class ProcessDeployer
implements Deployer {
    private static final Log log = Log.getLog((String)ProcessDeployer.class.getName());
    protected String extension;
    protected Parser parser;

    public ProcessDeployer(String extension, Parser parser) {
        this.extension = extension;
        this.parser = parser;
    }

    public void deploy(DeploymentImpl deployment) {
        for (String resourceName : deployment.getResourceNames()) {
            if (!resourceName.endsWith(this.extension)) continue;
            byte[] bytes = deployment.getBytes(resourceName);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            Parse parse = this.parser.createParse();
            parse.contextMapPut("deployment", deployment);
            parse.setProblems(deployment.getProblems());
            parse.setInputStream(inputStream);
            parse.execute();
            List processDefinitions = (List)parse.getDocumentObject();
            if (processDefinitions == null) continue;
            for (ProcessDefinitionImpl processDefinition : processDefinitions) {
                if (processDefinition == null || processDefinition.getName() == null) continue;
                processDefinition.setSuspended(deployment.isSuspended());
                String imageResourceName = resourceName.substring(0, resourceName.lastIndexOf(this.extension)) + ".png";
                if (deployment.getResourceNames().contains(imageResourceName)) {
                    processDefinition.setImageResourceName(imageResourceName);
                }
                processDefinition.setDeploymentDbid(deployment.getDbid());
                String processDefinitionName = processDefinition.getName();
                if (deployment.hasObjectProperties(processDefinitionName)) {
                    String key = deployment.getProcessDefinitionKey(processDefinitionName);
                    String id = deployment.getProcessDefinitionId(processDefinitionName);
                    Long version = deployment.getProcessDefinitionVersion(processDefinitionName);
                    processDefinition.setId(id);
                    processDefinition.setKey(key);
                    processDefinition.setVersion(version.intValue());
                } else {
                    MigrationDescriptor migrationDescriptor;
                    this.checkKey(processDefinition, deployment);
                    this.checkVersion(processDefinition, deployment);
                    this.checkId(processDefinition, deployment);
                    deployment.setProcessDefinitionId(processDefinitionName, processDefinition.getId());
                    deployment.setProcessDefinitionKey(processDefinitionName, processDefinition.getKey());
                    deployment.setProcessDefinitionVersion(processDefinitionName, new Long(processDefinition.getVersion()));
                    Map migrations = (Map)parse.contextMapGet("migrations");
                    if (migrations != null && (migrationDescriptor = (MigrationDescriptor)migrations.get(processDefinition)) != null) {
                        InstanceMigrator.migrateAll(processDefinition, migrationDescriptor);
                    }
                }
                deployment.addObject(processDefinitionName, processDefinition);
            }
        }
    }

    protected void checkKey(ProcessDefinitionImpl processDefinition, DeploymentImpl deployment) {
        String processDefinitionName = processDefinition.getName();
        String processDefinitionKey = processDefinition.getKey();
        if (processDefinitionKey == null) {
            processDefinitionKey = processDefinitionName.replaceAll("[^\\p{L}\\p{N}]", "_");
            processDefinition.setKey(processDefinitionKey);
        }
        RepositorySession repositorySession = EnvironmentImpl.getFromCurrent(RepositorySession.class);
        List existingProcesses = repositorySession.createProcessDefinitionQuery().processDefinitionName(processDefinitionName).list();
        for (ProcessDefinition existingProcess : existingProcesses) {
            if (processDefinitionKey.equals(existingProcess.getKey())) continue;
            deployment.addProblem("invalid key '" + processDefinitionKey + "' in process " + processDefinition.getName() + ".  Existing process has name '" + processDefinitionName + "' and key '" + existingProcess.getKey() + "'");
        }
        existingProcesses = repositorySession.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        for (ProcessDefinition existingProcess : existingProcesses) {
            if (processDefinitionName.equals(existingProcess.getName())) continue;
            deployment.addProblem("invalid name '" + processDefinitionName + "' in process " + processDefinition.getName() + ".  Existing process has name '" + existingProcess.getName() + "' and key '" + processDefinitionKey + "'");
        }
    }

    protected void checkId(ProcessDefinitionImpl processDefinition, DeploymentImpl deployment) {
        RepositorySession repositorySession;
        ProcessDefinition existingProcessDefinition;
        String id = processDefinition.getId();
        if (id == null) {
            id = processDefinition.getKey() + "-" + processDefinition.getVersion();
            if (log.isTraceEnabled()) {
                log.trace("created id '" + id + "' for " + processDefinition);
            }
            processDefinition.setId(id);
        }
        if ((existingProcessDefinition = (repositorySession = EnvironmentImpl.getFromCurrent(RepositorySession.class)).createProcessDefinitionQuery().processDefinitionId(id).uniqueResult()) != null) {
            deployment.addProblem("process '" + id + "' already exists");
        }
    }

    protected void checkVersion(ProcessDefinitionImpl processDefinition, DeploymentImpl deployment) {
        int version = processDefinition.getVersion();
        String key = processDefinition.getKey();
        if (version == -1) {
            RepositorySession repositorySession = EnvironmentImpl.getFromCurrent(RepositorySession.class);
            ProcessDefinition latestDeployedVersion = repositorySession.createProcessDefinitionQuery().processDefinitionKey(key).orderDesc("versionProperty.longValue").page(0, 1).uniqueResult();
            version = latestDeployedVersion != null ? latestDeployedVersion.getVersion() + 1 : 1;
            if (log.isTraceEnabled()) {
                log.trace("assigning version " + version + " to process definition " + key);
            }
            processDefinition.setVersion(version);
        }
    }

    public void updateResource(DeploymentImpl deployment, String resourceName, byte[] bytes) {
        deployment.addResourceFromInputStream(resourceName, new ByteArrayInputStream(bytes));
    }
}

