/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.util.Map;
import org.mule.MuleCoreExtension;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.application.DefaultMuleApplication;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;

public class PriviledgedMuleApplication
extends DefaultMuleApplication {
    public static final String REGISTRY_KEY_DEPLOYMENT_SERVICE = "_deploymentService";
    public static final String REGISTRY_KEY_CORE_EXTENSIONS = "_coreExtensions";
    protected DeploymentService deploymentService;
    protected Map<Class<? extends MuleCoreExtension>, MuleCoreExtension> coreExtensions;

    protected PriviledgedMuleApplication(ApplicationDescriptor appDescriptor) {
        super(appDescriptor);
    }

    @Override
    public void init() {
        if (this.deploymentService == null) {
            String msg = String.format("Deployment service ref wasn't provided for privileged app '%s'", this.getAppName());
            throw new DeploymentInitException(MessageFactory.createStaticMessage((String)msg));
        }
        super.init();
        try {
            if (this.getDescriptor().isPrivileged()) {
                this.getMuleContext().getRegistry().registerObject(REGISTRY_KEY_DEPLOYMENT_SERVICE, (Object)this.deploymentService);
                this.getMuleContext().getRegistry().registerObject(REGISTRY_KEY_CORE_EXTENSIONS, this.coreExtensions);
            }
        }
        catch (RegistrationException e) {
            String msg = String.format("Failed to init a privileged app: [%s]", this.getDescriptor().getAppName());
            throw new DeploymentInitException(MessageFactory.createStaticMessage((String)msg), e);
        }
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setCoreExtensions(Map<Class<? extends MuleCoreExtension>, MuleCoreExtension> coreExtensions) {
        this.coreExtensions = coreExtensions;
    }
}

