/*
 * $Id: SystemExceptionHandler.java 21903 2011-05-13 19:40:30Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.exception;

import org.mule.api.transaction.RollbackMethod;


/**
 * Take some action when a system exception has occurred (i.e., there was no message in play when the exception occurred).
 */
public interface SystemExceptionHandler extends ExceptionHandler
{
    /**
     * Take some action when a system exception has occurred (i.e., there was no message in play when the exception occurred).
     * 
     * @param exception which occurred
     * @param rollbackMethod will be called if transactions are not used in order to achieve atomic message delivery 
     */
    void handleException(Exception exception, RollbackMethod rollbackMethod);

    /**
     * Take some action when a system exception has occurred (i.e., there was no message in play when the exception occurred).
     * 
     * @param exception which occurred
     */
    void handleException(Exception exception);
}


