/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointCache;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;

public class SimpleEndpointCache
implements EndpointCache {
    protected MuleContext muleContext;
    private ConcurrentMap inboundEndpointCache = new ConcurrentHashMap();
    private ConcurrentMap outboundEndpointCache = new ConcurrentHashMap();

    public SimpleEndpointCache(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public OutboundEndpoint getOutboundEndpoint(String uri, MessageExchangePattern mep, Long responseTimeout) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.outboundEndpointCache.get(uri + ":" + mep.toString() + ":" + responseTimeout);
        if (endpoint == null) {
            EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(uri);
            endpointBuilder.setExchangePattern(mep);
            if (responseTimeout != null && responseTimeout > 0L) {
                endpointBuilder.setResponseTimeout(responseTimeout.intValue());
            }
            endpoint = this.muleContext.getEndpointFactory().getOutboundEndpoint(endpointBuilder);
            OutboundEndpoint concurrentlyAddedEndpoint = this.outboundEndpointCache.putIfAbsent(uri + ":" + mep.toString() + ":" + responseTimeout, endpoint);
            if (concurrentlyAddedEndpoint != null) {
                return concurrentlyAddedEndpoint;
            }
        }
        return endpoint;
    }

    @Override
    public InboundEndpoint getInboundEndpoint(String uri, MessageExchangePattern mep) throws MuleException {
        InboundEndpoint endpoint = (InboundEndpoint)this.inboundEndpointCache.get(uri + ":" + mep.toString());
        if (endpoint == null) {
            EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(uri);
            endpointBuilder.setExchangePattern(mep);
            endpoint = this.muleContext.getEndpointFactory().getInboundEndpoint(endpointBuilder);
            InboundEndpoint concurrentlyAddedEndpoint = this.inboundEndpointCache.putIfAbsent(uri + ":" + mep.toString(), endpoint);
            if (concurrentlyAddedEndpoint != null) {
                return concurrentlyAddedEndpoint;
            }
        }
        return endpoint;
    }
}

