/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.correlation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.buffer.BoundedFifoBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessageCollection;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.RoutingNotification;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.CorrelationTimeoutException;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.util.StringMessageUtils;
import org.mule.util.concurrent.ThreadNameHelper;
import org.mule.util.monitor.Expirable;
import org.mule.util.monitor.ExpiryMonitor;

public class EventCorrelator
implements Startable,
Stoppable {
    protected final transient Log logger = LogFactory.getLog(EventCorrelator.class);
    public static final String NO_CORRELATION_ID = "no-id";
    public static final int MAX_PROCESSED_GROUPS = 50000;
    protected static final long MILLI_TO_NANO_MULTIPLIER = 1000000L;
    private static final long ONE_DAY_IN_MILLI = 86400000L;
    protected long groupTimeToLive = 86400000L;
    protected final ConcurrentMap eventGroups = new ConcurrentHashMap();
    protected final Object groupsLock = new Object();
    protected final BoundedFifoBuffer processedGroups = new BoundedFifoBuffer(50000);
    private long timeout = -1L;
    private boolean failOnTimeout = true;
    private MessageInfoMapping messageInfoMapping;
    private MuleContext muleContext;
    private EventCorrelatorCallback callback;
    private MessageProcessor timeoutMessageProcessor;
    private Map expiredAndDispatchedGroups = new ConcurrentHashMap();
    private ExpiringGroupMonitoringThread expiringGroupMonitoringThread;
    private final String name;

    public EventCorrelator(EventCorrelatorCallback callback, MessageProcessor timeoutMessageProcessor, MessageInfoMapping messageInfoMapping, MuleContext muleContext, String flowConstructName) {
        if (callback == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("EventCorrelatorCallback").getMessage());
        }
        if (messageInfoMapping == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("MessageInfoMapping").getMessage());
        }
        if (muleContext == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("MuleContext").getMessage());
        }
        this.callback = callback;
        this.messageInfoMapping = messageInfoMapping;
        this.muleContext = muleContext;
        this.timeoutMessageProcessor = timeoutMessageProcessor;
        this.name = String.format("%s%s.event.correlator", ThreadNameHelper.getPrefix(muleContext), flowConstructName);
    }

    public void forceGroupExpiry(String groupId) throws MessagingException {
        if (this.eventGroups.get(groupId) != null) {
            this.handleGroupExpiry((EventGroup)this.eventGroups.get(groupId));
        } else {
            this.addProcessedGroup(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MuleEvent process(MuleEvent event) throws RoutingException {
        EventGroup group;
        String groupId = this.messageInfoMapping.getCorrelationId(event.getMessage());
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)String.format("Received async reply message for correlationID: %s%n%s%n%s", groupId, StringMessageUtils.truncate(StringMessageUtils.toString(event.getMessage().getPayload()), 200, false), StringMessageUtils.headersToString(event.getMessage())));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (groupId == null || groupId.equals("-1")) {
            throw new RoutingException(CoreMessages.noCorrelationId(), event, this.timeoutMessageProcessor);
        }
        boolean lookupMiss = false;
        while (true) {
            if (lookupMiss) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isGroupAlreadyProcessed(groupId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("An event was received for an event group that has already been processed, this is probably because the async-reply timed out. Correlation Id is: " + groupId + ". Dropping event"));
                }
                this.muleContext.fireNotification(new RoutingNotification(event.getMessage(), event.getEndpoint().getEndpointURI().toString(), 1304));
                return null;
            }
            group = this.getEventGroup(groupId);
            if (group == null) {
                group = this.addEventGroup(this.callback.createEventGroup(event, groupId));
            }
            Object object = this.groupsLock;
            synchronized (object) {
                if (group == this.getEventGroup(groupId)) break;
                lookupMiss = true;
            }
        }
        {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding event to aggregator group: " + groupId));
            }
            group.addEvent(event);
            if (this.callback.shouldAggregateEvents(group)) {
                MuleEvent returnEvent = this.callback.aggregateEvents(group);
                returnEvent.getMessage().setCorrelationId(groupId);
                this.removeEventGroup(group);
                return returnEvent;
            }
            return null;
        }
    }

    protected EventGroup getEventGroup(String groupId) {
        return (EventGroup)this.eventGroups.get(groupId);
    }

    protected EventGroup addEventGroup(EventGroup group) {
        EventGroup previous = this.eventGroups.putIfAbsent(group.getGroupId(), group);
        return previous != null ? previous : group;
    }

    protected void removeEventGroup(EventGroup group) {
        Object groupId = group.getGroupId();
        this.eventGroups.remove(groupId);
        this.addProcessedGroup(groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProcessedGroup(Object id) {
        Object object = this.groupsLock;
        synchronized (object) {
            if (this.processedGroups.isFull()) {
                this.processedGroups.remove();
            }
            this.processedGroups.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isGroupAlreadyProcessed(Object id) {
        Object object = this.groupsLock;
        synchronized (object) {
            return this.processedGroups.contains(id);
        }
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void handleGroupExpiry(EventGroup group) throws MessagingException {
        this.removeEventGroup(group);
        FlowConstruct service = group.toArray()[0].getFlowConstruct();
        if (this.isFailOnTimeout()) {
            MuleMessageCollection messageCollection = group.toMessageCollection();
            this.muleContext.fireNotification(new RoutingNotification(messageCollection, null, 1303));
            throw new CorrelationTimeoutException(CoreMessages.correlationTimedOut(group.getGroupId()), group.getMessageCollectionEvent());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Aggregator expired, but ''failOnTimeOut'' is false. Forwarding {0} events out of {1} total for group ID: {2}", group.size(), group.expectedSize(), group.getGroupId()));
        }
        try {
            if (group.getCreated() + this.groupTimeToLive >= System.currentTimeMillis()) {
                MuleEvent newEvent = this.callback.aggregateEvents(group);
                newEvent.getMessage().setCorrelationId(group.getGroupId().toString());
                if (!this.expiredAndDispatchedGroups.containsKey(group.getGroupId())) {
                    if (this.timeoutMessageProcessor != null) {
                        this.timeoutMessageProcessor.process(newEvent);
                    } else {
                        if (!(service instanceof Service)) {
                            throw new UnsupportedOperationException("EventAggregator is only supported with Service");
                        }
                        ((Service)service).dispatchEvent(newEvent);
                    }
                    this.expiredAndDispatchedGroups.put(group.getGroupId(), group.getCreated());
                } else {
                    this.logger.warn((Object)MessageFormat.format("Discarding group {0}", group.getGroupId()));
                }
            }
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessagingException(group.getMessageCollectionEvent(), (Throwable)e);
        }
    }

    @Override
    public void start() throws MuleException {
        this.logger.info((Object)("Starting event correlator: " + this.name));
        if (this.timeout != 0L) {
            this.expiringGroupMonitoringThread = new ExpiringGroupMonitoringThread();
            this.expiringGroupMonitoringThread.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        this.logger.info((Object)("Stopping event correlator: " + this.name));
        if (this.expiringGroupMonitoringThread != null) {
            this.expiringGroupMonitoringThread.stopProcessing();
        }
    }

    private final class ExpiringGroupMonitoringThread
    extends Thread
    implements Expirable {
        private ExpiryMonitor expiryMonitor;
        private volatile boolean stopRequested;

        public ExpiringGroupMonitoringThread() {
            this.setName(EventCorrelator.this.name);
            this.expiryMonitor = new ExpiryMonitor(EventCorrelator.this.name, 60000);
            this.expiryMonitor.addExpirable(1800000L, TimeUnit.MILLISECONDS, this);
        }

        @Override
        public void expired() {
            for (Object o : EventCorrelator.this.expiredAndDispatchedGroups.keySet()) {
                Long time = (Long)EventCorrelator.this.expiredAndDispatchedGroups.get(o);
                if (time + EventCorrelator.this.groupTimeToLive >= System.currentTimeMillis()) continue;
                EventCorrelator.this.expiredAndDispatchedGroups.remove(o);
                EventCorrelator.this.logger.warn((Object)MessageFormat.format("Discarding group {0}", o));
            }
        }

        public void release() {
        }

        @Override
        public void run() {
            while (true) {
                EventGroup group;
                if (this.stopRequested) {
                    EventCorrelator.this.logger.debug((Object)"Received request to stop expiring group monitoring");
                    break;
                }
                ArrayList<EventGroup> expired = new ArrayList<EventGroup>(1);
                for (Object o : EventCorrelator.this.eventGroups.values()) {
                    group = (EventGroup)o;
                    if (group.getCreated() + EventCorrelator.this.getTimeout() * 1000000L >= System.nanoTime()) continue;
                    expired.add(group);
                }
                if (expired.size() > 0) {
                    Iterator<Object> i$ = expired.iterator();
                    while (i$.hasNext()) {
                        EventGroup anExpired;
                        group = anExpired = (EventGroup)i$.next();
                        try {
                            EventCorrelator.this.handleGroupExpiry(group);
                        }
                        catch (MessagingException e) {
                            e.getEvent().getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            EventCorrelator.this.logger.debug((Object)"Expiring group monitoring fully stopped");
        }

        public void stopProcessing() {
            EventCorrelator.this.logger.debug((Object)"Stopping expiring group monitoring");
            this.stopRequested = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

