/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AbstractLeftTupleSinkAdapter;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.RightTuple;
import org.drools.spi.PropagationContext;

public class SingleLeftTupleSinkAdapter
extends AbstractLeftTupleSinkAdapter {
    protected LeftTupleSink sink;

    public SingleLeftTupleSinkAdapter() {
        this(RuleBasePartitionId.MAIN_PARTITION, null);
    }

    public SingleLeftTupleSinkAdapter(RuleBasePartitionId partitionId, LeftTupleSink sink) {
        super(partitionId);
        this.sink = sink;
    }

    public void propagateAssertLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        this.doPropagateAssertLeftTuple(context, workingMemory, new LeftTuple(leftTuple, rightTuple, this.sink, leftTupleMemoryEnabled));
    }

    public void propagateAssertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        this.doPropagateAssertLeftTuple(context, workingMemory, new LeftTuple(tuple, this.sink, leftTupleMemoryEnabled));
    }

    public void propagateRetractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getBetaChildren();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    public void propagateRetractLeftTupleDestroyRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getBetaChildren();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            workingMemory.getFactHandleFactory().destroyFactHandle(child.getRightParent().getFactHandle());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    public void propagateRetractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = rightTuple.getBetaChildren();
        while (child != null) {
            LeftTuple temp = child.getRightParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = temp;
        }
    }

    public void createAndPropagateAssertLeftTuple(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        this.doPropagateAssertLeftTuple(context, workingMemory, new LeftTuple(factHandle, this.sink, leftTupleMemoryEnabled));
    }

    public BaseNode getMatchingNode(BaseNode candidate) {
        if (candidate.equals(this.sink)) {
            return (BaseNode)((Object)this.sink);
        }
        return null;
    }

    public LeftTupleSink[] getSinks() {
        return new LeftTupleSink[]{this.sink};
    }

    public int size() {
        return this.sink != null ? 1 : 0;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (LeftTupleSink)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
    }

    protected void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple newLeftTuple) {
        this.sink.assertLeftTuple(newLeftTuple, context, workingMemory);
    }

    protected void doPropagateRetractLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple child, LeftTupleSink tupleSink) {
        tupleSink.retractLeftTuple(child, context, workingMemory);
    }
}

