/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;

public class KeyValueToken
extends Token {
    boolean forceRsaKeyValue;

    public KeyValueToken(SPConstants version) {
        super(version);
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getKeyValueToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        QName name = this.constants.getUserNameToken();
        String localname = name.getLocalPart();
        String namespaceURI = name.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = name.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.forceRsaKeyValue) {
            String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
            if (pPrefix == null) {
                writer.setPrefix(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getNamespaceURI());
            }
            writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
            writer.writeEmptyElement(prefix, "RsaKeyValue", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void setForceRsaKeyValue(boolean b) {
        this.forceRsaKeyValue = b;
    }

    public boolean isForceRsaKeyValue() {
        return this.forceRsaKeyValue;
    }
}

