/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Properties;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityToken {
    private String id;
    private State state = State.UNKNOWN;
    private Element token;
    private Element previousToken;
    private Element attachedReference;
    private Element unattachedReference;
    private Properties properties;
    private boolean changed;
    private byte[] secret;
    private Calendar created;
    private Calendar expires;
    private String issuerAddress;
    private String encrKeySha1Value;
    private String tokenType;
    private X509Certificate x509cert;
    private Crypto crypto;

    public SecurityToken() {
    }

    public SecurityToken(String id, Calendar created, Calendar expires) {
        this.id = id;
        this.created = created;
        this.expires = expires;
    }

    public SecurityToken(String id, Element tokenElem, Calendar created, Calendar expires) {
        this.id = id;
        this.token = SecurityToken.cloneElement(tokenElem);
        this.created = created;
        this.expires = expires;
    }

    public SecurityToken(String id, Element tokenElem, Element lifetimeElem) {
        this.id = id;
        this.token = SecurityToken.cloneElement(tokenElem);
        if (lifetimeElem != null) {
            this.processLifeTime(lifetimeElem);
        }
    }

    private static Element cloneElement(Element el) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            writer.setNsRepairing(true);
            StaxUtils.copy((Element)el, (XMLStreamWriter)writer);
            return writer.getDocument().getDocumentElement();
        }
        catch (Exception exception) {
            return el;
        }
    }

    private void processLifeTime(Element lifetimeElem) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Element createdElem = DOMUtils.getFirstChildWithName((Element)lifetimeElem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Created");
            this.created = factory.newXMLGregorianCalendar(DOMUtils.getContent((Node)createdElem)).toGregorianCalendar();
            Element expiresElem = DOMUtils.getFirstChildWithName((Element)lifetimeElem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Expires");
            this.expires = factory.newXMLGregorianCalendar(DOMUtils.getContent((Node)expiresElem)).toGregorianCalendar();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean chnaged) {
        this.changed = chnaged;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Element getToken() {
        return this.token;
    }

    public void setToken(Element token) {
        this.token = token;
    }

    public String getId() {
        return this.id;
    }

    public Element getPreviousToken() {
        return this.previousToken;
    }

    public void setPreviousToken(Element previousToken) {
        this.previousToken = SecurityToken.cloneElement(previousToken);
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public void setSecret(byte[] secret) {
        this.secret = secret;
    }

    public Element getAttachedReference() {
        return this.attachedReference;
    }

    public void setAttachedReference(Element attachedReference) {
        if (attachedReference != null) {
            this.attachedReference = SecurityToken.cloneElement(attachedReference);
        }
    }

    public Element getUnattachedReference() {
        return this.unattachedReference;
    }

    public void setUnattachedReference(Element unattachedReference) {
        if (unattachedReference != null) {
            this.unattachedReference = SecurityToken.cloneElement(unattachedReference);
        }
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public void setExpires(Calendar expires) {
        this.expires = expires;
    }

    public String getIssuerAddress() {
        return this.issuerAddress;
    }

    public void setIssuerAddress(String issuerAddress) {
        this.issuerAddress = issuerAddress;
    }

    public void setSHA1(String sha) {
        this.encrKeySha1Value = sha;
    }

    public String getSHA1() {
        return this.encrKeySha1Value;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String s) {
        this.tokenType = s;
    }

    public String getWsuId() {
        String t;
        Element elem = this.getAttachedReference();
        if (elem != null && (t = SecurityToken.getIdFromSTR(elem)) != null) {
            return t;
        }
        elem = this.getUnattachedReference();
        if (elem != null && (t = SecurityToken.getIdFromSTR(elem)) != null) {
            return t;
        }
        return null;
    }

    public static String getIdFromSTR(Element str) {
        Element child = DOMUtils.getFirstElement((Node)str);
        if (child == null) {
            return null;
        }
        if ("KeyInfo".equals(child.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
            return DOMUtils.getContent((Node)child);
        }
        if (Reference.TOKEN.getLocalPart().equals(child.getLocalName()) && Reference.TOKEN.getNamespaceURI().equals(child.getNamespaceURI())) {
            return child.getAttribute("URI").substring(1);
        }
        return null;
    }

    public void setX509Certificate(X509Certificate cert, Crypto cpt) {
        this.x509cert = cert;
        this.crypto = cpt;
    }

    public X509Certificate getX509Certificate() {
        return this.x509cert;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        ISSUED,
        EXPIRED,
        CANCELLED,
        RENEWED;

    }
}

