/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.mule.transport.jdbc.config.AbstractDataSourceFactoryBean;

public class OracleDataSourceFactoryBean
extends AbstractDataSourceFactoryBean {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_INSTANCE = "orcl";
    private static final int DEFAULT_PORT = 1521;
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:oracle:thin:@";
    protected String host = "localhost";
    protected int port = 1521;
    protected String instance = "orcl";

    public OracleDataSourceFactoryBean() {
        this.driverClassName = DRIVER_CLASS_NAME;
        this.updateUrl();
    }

    protected void updateUrl() {
        StringBuilder buf = new StringBuilder(JDBC_URL_PREFIX);
        buf.append(this.host);
        buf.append(":");
        buf.append(this.port);
        buf.append(":");
        buf.append(this.instance);
        this.url = buf.toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.updateUrl();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.updateUrl();
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
        this.updateUrl();
    }
}

