/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.Collections;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.AbstractFlowConstuctTestCase;
import org.mule.construct.Validator;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.tck.MuleTestUtils;

public class ValidatorTestCase
extends AbstractFlowConstuctTestCase {
    private Validator validator;
    protected Connector testConnector;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        OutboundEndpoint testOutboundEndpoint = MuleTestUtils.getTestOutboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        this.testConnector = testOutboundEndpoint.getConnector();
        muleContext.getRegistry().registerConnector(this.testConnector);
        this.testConnector.start();
        this.validator = new Validator("test-validator", muleContext, (MessageSource)this.directInboundMessageSource, testOutboundEndpoint, (Filter)new PayloadTypeFilter(Integer.class), "#[string:GOOD:#[message:payload]]", "#[string:BAD:#[message:payload]]");
    }

    @Override
    protected AbstractFlowConstruct getFlowConstruct() throws Exception {
        return this.validator;
    }

    public void testAck() throws Exception {
        this.validator.initialise();
        this.validator.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent(123, muleContext));
        ValidatorTestCase.assertEquals((String)"GOOD:123", (String)response.getMessageAsString());
    }

    public void testNack() throws Exception {
        this.validator.initialise();
        this.validator.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent("abc", muleContext));
        ValidatorTestCase.assertEquals((String)"BAD:abc", (String)response.getMessageAsString());
    }

    public void testErrorWithoutExpression() throws Exception {
        OutboundEndpoint failingOutboundEndpoint = MuleTestUtils.getTestOutboundEndpoint("failing-oe", muleContext, "test://AlwaysFail", Collections.EMPTY_LIST, null, Collections.EMPTY_MAP, this.testConnector);
        this.validator = new Validator("test-validator", muleContext, (MessageSource)this.directInboundMessageSource, failingOutboundEndpoint, (Filter)new PayloadTypeFilter(Integer.class), "#[string:GOOD:#[message:payload]]", "#[string:BAD:#[message:payload]]");
        this.testAck();
    }

    public void testErrorWithExpression() throws Exception {
        OutboundEndpoint failingOutboundEndpoint = MuleTestUtils.getTestOutboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE, muleContext, "test://AlwaysFail", this.testConnector);
        this.validator = new Validator("test-validator", muleContext, (MessageSource)this.directInboundMessageSource, failingOutboundEndpoint, (Filter)new PayloadTypeFilter(Integer.class), "#[string:GOOD:#[message:payload]]", "#[string:BAD:#[message:payload]]", "#[string:ERROR:#[message:payload]]");
        this.validator.initialise();
        this.validator.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent(123, muleContext));
        ValidatorTestCase.assertEquals((String)"ERROR:123", (String)response.getMessageAsString());
    }
}

