/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.expression.MessageAttachmentExpressionEvaluator;
import org.mule.expression.MessageAttachmentsExpressionEvaluator;
import org.mule.expression.MessageAttachmentsListExpressionEvaluator;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.StringDataSource;

public class AttachmentsExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private MuleMessage message;

    @Override
    protected void doSetUp() throws Exception {
        try {
            HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
            attachments.put("foo", new DataHandler((DataSource)new StringDataSource("foovalue")));
            attachments.put("bar", new DataHandler((DataSource)new StringDataSource("barvalue")));
            attachments.put("baz", new DataHandler((DataSource)new StringDataSource("bazvalue")));
            this.message = new DefaultMuleMessage((Object)"test", null, attachments, muleContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            AttachmentsExpressionEvaluatorTestCase.fail((String)e.getMessage());
        }
    }

    public void testSingleAttachment() throws Exception {
        MessageAttachmentExpressionEvaluator eval = new MessageAttachmentExpressionEvaluator();
        Object result = eval.evaluate("foo", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"foovalue", (String)baos.toString());
        result = eval.evaluate("foo?", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"foovalue", (String)baos.toString());
        result = eval.evaluate("fool?", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            eval.evaluate("fool", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testMapAttachments() throws Exception {
        MessageAttachmentsExpressionEvaluator eval = new MessageAttachmentsExpressionEvaluator();
        Object result = eval.evaluate("foo, baz", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"foovalue", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"bazvalue", (String)baos.toString());
        result = eval.evaluate("fool?", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        try {
            eval.evaluate("fool", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testMapAttachmentsWithWildcards() throws Exception {
        MessageAttachmentsExpressionEvaluator eval = new MessageAttachmentsExpressionEvaluator();
        Object result = eval.evaluate("*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("bar"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        result = eval.evaluate("ba*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("bar"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        result = eval.evaluate("x*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = eval.evaluate("ba*, f*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("bar"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
    }

    public void testListAttachments() throws Exception {
        MessageAttachmentsListExpressionEvaluator eval = new MessageAttachmentsListExpressionEvaluator();
        Object result = eval.evaluate("foo, baz", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"foovalue", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"bazvalue", (String)baos.toString());
        result = eval.evaluate("*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        result = eval.evaluate("fool?", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        try {
            eval.evaluate("fool", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testListAttachmentsWithWildcards() throws Exception {
        MessageAttachmentsListExpressionEvaluator eval = new MessageAttachmentsListExpressionEvaluator();
        Object result = eval.evaluate("*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        result = eval.evaluate("ba*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        result = eval.evaluate("x*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = eval.evaluate("ba*, f*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
    }

    public void testSingleAttachmentUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachment:foo]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"foovalue", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachment:fool?]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[attachment:fool]", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    public void testMapAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:foo, baz]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"foovalue", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"bazvalue", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachments:fool?]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[attachments:fool]", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
    }

    public void testMapAttachmentsWithWildcardsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("bar"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        result = muleContext.getExpressionManager().evaluate("#[attachments:ba*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("bar"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        result = muleContext.getExpressionManager().evaluate("#[attachments:x*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments:ba*, f*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("bar"));
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
    }

    public void testListAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:foo,baz]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"foovalue", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"bazvalue", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:fool?]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[attachments-list:fool]", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
    }

    public void testListAttachmentsWithWildcardsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:ba*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:x*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:ba*, f*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
    }
}

