/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.MessageProcessorExpressionEvaluator;
import org.mule.tck.AbstractMuleTestCase;

public class MessageProcessorExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private ExpressionManager expressionManager;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.expressionManager = muleContext.getExpressionManager();
        RequestContext.setEvent((MuleEvent)MessageProcessorExpressionEvaluatorTestCase.getTestEvent(""));
        muleContext.getRegistry().registerObject("processor", (Object)new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)(event.getMessageAsString() + "123"));
                return event;
            }
        });
    }

    public void testNameOnly() throws Exception {
        MessageProcessorExpressionEvaluator evaluator = new MessageProcessorExpressionEvaluator();
        MessageProcessorExpressionEvaluatorTestCase.assertEquals((String)"0123", (String)((MuleMessage)evaluator.evaluate("processor", this.createTestMessage())).getPayloadAsString());
    }

    public void testNameOnlyExpressionManager() throws ExpressionRuntimeException, Exception {
        MessageProcessorExpressionEvaluatorTestCase.assertEquals((String)"0123", (String)((MuleMessage)this.expressionManager.evaluate("#[process:processor]", this.createTestMessage())).getPayloadAsString());
    }

    public void testNestedPayloadExpression() throws Exception {
        MessageProcessorExpressionEvaluator evaluator = new MessageProcessorExpressionEvaluator();
        MessageProcessorExpressionEvaluatorTestCase.assertEquals((String)"0123", (String)((MuleMessage)evaluator.evaluate("processor:payload", this.createTestMessage())).getPayloadAsString());
    }

    public void testNestedPayloadExpressionExpressionManager() throws ExpressionRuntimeException, Exception {
        MessageProcessorExpressionEvaluatorTestCase.assertEquals((String)"0123", (String)((MuleMessage)this.expressionManager.evaluate("#[process:processor:#[payload]]", this.createTestMessage())).getPayloadAsString());
    }

    public void testNestedHeaderExpression() throws Exception {
        MessageProcessorExpressionEvaluator evaluator = new MessageProcessorExpressionEvaluator();
        MessageProcessorExpressionEvaluatorTestCase.assertEquals((String)"value123", (String)((MuleMessage)evaluator.evaluate("processor:header:one", this.createTestMessage())).getPayloadAsString());
    }

    public void testNestedHeaderExpressionExpressionManager() throws ExpressionRuntimeException, Exception {
        MessageProcessorExpressionEvaluatorTestCase.assertEquals((String)"value123", (String)((MuleMessage)this.expressionManager.evaluate("#[process:processor:#[header:one]]", this.createTestMessage())).getPayloadAsString());
    }

    private MuleMessage createTestMessage() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        message.setProperty("one", (Object)"value", PropertyScope.OUTBOUND);
        return message;
    }
}

