/*
 * Decompiled with CFR 0.152.
 */
package org.mule.object;

import org.mule.api.lifecycle.InitialisationException;
import org.mule.object.AbstractObjectFactory;
import org.mule.tck.AbstractMuleTestCase;

public abstract class AbstractObjectFactoryTestCase
extends AbstractMuleTestCase {
    public void testInitialisationFailureWithoutObjectClass() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        try {
            factory.initialise();
            AbstractObjectFactoryTestCase.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    public void testInstanceFailureGetInstanceWithoutObjectClass() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        try {
            factory.getInstance(muleContext);
            AbstractObjectFactoryTestCase.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    public void testCreateWithClassButDoNotInitialise() throws Exception {
        DummyObjectFactory factory = new DummyObjectFactory(Object.class);
        this.assertObjectClassAndName(factory);
    }

    public void testCreateWithClassNameButDoNotInitialise() throws Exception {
        DummyObjectFactory factory = new DummyObjectFactory(Object.class.getName());
        this.assertObjectClassAndName(factory);
    }

    public void testSetObjectClassNameButDoNotInitialise() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClassName(Object.class.getName());
        this.assertObjectClassAndName(factory);
    }

    public void testSetObjectClassButDoNotInitialise() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClass(Object.class);
        this.assertObjectClassAndName(factory);
    }

    private void assertObjectClassAndName(AbstractObjectFactory factory) {
        AbstractObjectFactoryTestCase.assertEquals(Object.class, (Object)factory.getObjectClass());
        AbstractObjectFactoryTestCase.assertEquals((String)Object.class.getName(), (String)factory.getObjectClassName());
    }

    public void testInitialiseWithClass() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClass(Object.class);
        muleContext.getRegistry().applyProcessorsAndLifecycle((Object)factory);
        AbstractObjectFactoryTestCase.assertNotNull((Object)factory.getInstance(muleContext));
    }

    public void testInitialiseWithClassName() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClassName(Object.class.getName());
        muleContext.getRegistry().applyProcessorsAndLifecycle((Object)factory);
        AbstractObjectFactoryTestCase.assertNotNull((Object)factory.getInstance(muleContext));
    }

    public void testDispose() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClass(Object.class);
        muleContext.getRegistry().applyProcessorsAndLifecycle((Object)factory);
        factory.dispose();
        try {
            factory.getInstance(muleContext);
            AbstractObjectFactoryTestCase.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    public abstract AbstractObjectFactory getUninitialisedObjectFactory();

    public abstract void testGetObjectClass() throws Exception;

    public abstract void testGet() throws Exception;

    private static class DummyObjectFactory
    extends AbstractObjectFactory {
        public DummyObjectFactory(String className) {
            super(className);
        }

        public DummyObjectFactory(Class<?> klass) {
            super(klass);
        }
    }
}

