/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.beans.ExceptionListener;
import java.util.concurrent.TimeUnit;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.Transaction;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.concurrent.Latch;

public class AsyncInterceptingMessageProcessorTestCase
extends AbstractMuleTestCase
implements ExceptionListener {
    protected MessageProcessor messageProcessor;
    protected TestListener target = new TestListener();
    protected Exception exceptionThrown;
    protected Latch latch = new Latch();

    public AsyncInterceptingMessageProcessorTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.messageProcessor = this.createAsyncInterceptingMessageProcessor(this.target);
    }

    public void testProcessOneWay() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        MuleEvent result = this.messageProcessor.process(event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        AsyncInterceptingMessageProcessorTestCase.assertNotNull((Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertNotSame((Object)event, (Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertEquals((String)event.getMessageAsString(), (String)this.target.sensedEvent.getMessageAsString());
        AsyncInterceptingMessageProcessorTestCase.assertNull((Object)result);
        AsyncInterceptingMessageProcessorTestCase.assertNull((Object)this.exceptionThrown);
    }

    public void testProcessRequestResponse() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        this.assertAsync(this.messageProcessor, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProcessOneWayWithTx() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestTransactedInboundEndpoint(MessageExchangePattern.ONE_WAY));
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            this.messageProcessor.process(event);
            AsyncInterceptingMessageProcessorTestCase.fail((String)"Exception expected");
        }
        catch (Exception e) {
            AsyncInterceptingMessageProcessorTestCase.assertTrue((boolean)(e instanceof MessagingException));
            AsyncInterceptingMessageProcessorTestCase.assertNull((Object)this.target.sensedEvent);
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProcessRequestResponseWithTx() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestTransactedInboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE));
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            this.messageProcessor.process(event);
            AsyncInterceptingMessageProcessorTestCase.fail((String)"Exception expected");
        }
        catch (Exception e) {
            AsyncInterceptingMessageProcessorTestCase.assertTrue((boolean)(e instanceof MessagingException));
            AsyncInterceptingMessageProcessorTestCase.assertNull((Object)this.target.sensedEvent);
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    protected void assertSync(MessageProcessor processor, MuleEvent event) throws MuleException {
        MuleEvent result = processor.process(event);
        AsyncInterceptingMessageProcessorTestCase.assertSame((Object)event, (Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertSame((Object)event, (Object)result);
    }

    protected void assertAsync(MessageProcessor processor, MuleEvent event) throws MuleException, InterruptedException {
        MuleEvent result = processor.process(event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        AsyncInterceptingMessageProcessorTestCase.assertNotNull((Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertNotSame((Object)event, (Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertEquals((String)event.getMessageAsString(), (String)this.target.sensedEvent.getMessageAsString());
        AsyncInterceptingMessageProcessorTestCase.assertNull((Object)result);
        AsyncInterceptingMessageProcessorTestCase.assertNull((Object)this.exceptionThrown);
    }

    protected AsyncInterceptingMessageProcessor createAsyncInterceptingMessageProcessor(MessageProcessor listener) throws Exception {
        AsyncInterceptingMessageProcessor mp = new AsyncInterceptingMessageProcessor((WorkManagerSource)new TestWorkManagerSource(), true);
        mp.setListener(listener);
        return mp;
    }

    @Override
    public void exceptionThrown(Exception e) {
        this.exceptionThrown = e;
    }

    class TestWorkManagerSource
    implements WorkManagerSource {
        TestWorkManagerSource() {
        }

        public WorkManager getWorkManager() throws MuleException {
            return muleContext.getWorkManager();
        }
    }

    class TestListener
    implements MessageProcessor {
        MuleEvent sensedEvent;

        TestListener() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.sensedEvent = event;
            AsyncInterceptingMessageProcessorTestCase.this.latch.countDown();
            return event;
        }
    }
}

