/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.CollectionUtils;

public class CatchAllStrategiesTestCase
extends AbstractMuleTestCase {
    public CatchAllStrategiesTestCase() {
        this.setStartContext(true);
    }

    public void testLoggingOnlyStrategy() throws Exception {
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        LoggingCatchAllStrategy strategy = new LoggingCatchAllStrategy();
        strategy.process(event);
    }

    public void testForwardingStrategy() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        Mock endpoint = MuleTestUtils.getMockOutboundEndpoint();
        Mock dispatcher = new Mock(MessageDispatcher.class);
        Mock connector = MuleTestUtils.getMockConnector();
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        strategy.setEndpoint((OutboundEndpoint)endpoint.proxy());
        endpoint.expect("process", (Object)C.isA(DefaultMuleEvent.class));
        strategy.process(event);
        endpoint.verify();
        dispatcher.verify();
        connector.verify();
        CatchAllStrategiesTestCase.assertNotNull((Object)strategy.getEndpoint());
    }

    public void testForwardingStrategyNullEndpoint() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        strategy.setEndpoint(null);
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        MuleSession session = CatchAllStrategiesTestCase.getTestSession(CatchAllStrategiesTestCase.getTestService(), muleContext);
        try {
            strategy.process(event);
            CatchAllStrategiesTestCase.fail();
        }
        catch (RoutingException sre) {
            // empty catch block
        }
    }

    public void testForwardingStrategyWithTransform() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        strategy.setSendTransformed(true);
        Mock endpoint = MuleTestUtils.getMockOutboundEndpoint();
        Mock dispatcher = new Mock(MessageDispatcher.class);
        Mock connector = MuleTestUtils.getMockConnector();
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        strategy.setEndpoint((OutboundEndpoint)endpoint.proxy());
        endpoint.expectAndReturn("getTransformers", (Object)CollectionUtils.singletonList((Object)((Object)new TestEventTransformer())));
        endpoint.expectAndReturn("getTransformers", (Object)CollectionUtils.singletonList((Object)((Object)new TestEventTransformer())));
        endpoint.expect("process", (Object)new Constraint(){

            public boolean eval(Object object) {
                if (object instanceof MuleEvent) {
                    return "Transformed Test Data".equals(((MuleEvent)object).getMessage().getPayload());
                }
                return false;
            }
        });
        strategy.process(event);
        endpoint.verify();
        dispatcher.verify();
        connector.verify();
        CatchAllStrategiesTestCase.assertNotNull((Object)strategy.getEndpoint());
    }

    public void testFullRouter() throws Exception {
        final int[] count1 = new int[]{0};
        final int[] count2 = new int[]{0};
        final int[] catchAllCount = new int[]{0};
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        FilteringOutboundRouter filterRouter1 = new FilteringOutboundRouter(){

            public MuleEvent route(MuleEvent event) {
                count1[0] = count1[0] + 1;
                return event;
            }
        };
        FilteringOutboundRouter filterRouter2 = new FilteringOutboundRouter(){

            public MuleEvent route(MuleEvent event) {
                count2[0] = count2[0] + 1;
                return event;
            }
        };
        filterRouter1.setFilter((Filter)new PayloadTypeFilter(Exception.class));
        filterRouter2.setFilter((Filter)new PayloadTypeFilter(StringBuffer.class));
        messageRouter.addRoute((MatchableMessageProcessor)filterRouter1);
        messageRouter.addRoute((MatchableMessageProcessor)filterRouter2);
        AbstractCatchAllStrategy strategy = new AbstractCatchAllStrategy(){

            public MuleEvent doCatchMessage(MuleEvent event) {
                catchAllCount[0] = catchAllCount[0] + 1;
                return null;
            }
        };
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)strategy);
        MuleSession session = CatchAllStrategiesTestCase.getTestSession(CatchAllStrategiesTestCase.getTestService(), muleContext);
        messageRouter.process(CatchAllStrategiesTestCase.getTestEvent("hello"));
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        CatchAllStrategiesTestCase.assertEquals((int)0, (int)count1[0]);
        CatchAllStrategiesTestCase.assertEquals((int)0, (int)count2[0]);
        messageRouter.process(CatchAllStrategiesTestCase.getTestEvent(new StringBuffer()));
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        CatchAllStrategiesTestCase.assertEquals((int)0, (int)count1[0]);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)count2[0]);
        messageRouter.process(CatchAllStrategiesTestCase.getTestEvent(new Exception()));
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)count1[0]);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)count2[0]);
    }

    private static class TestEventTransformer
    extends AbstractTransformer {
        public Object doTransform(Object src, String encoding) throws TransformerException {
            return "Transformed Test Data";
        }
    }
}

