/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.routing.MessageChunkAggregator;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;

public class MessageChunkAggregatorTestCase
extends AbstractMuleTestCase {
    public MessageChunkAggregatorTestCase() {
        this.setStartContext(true);
    }

    public void testMessageProcessor() throws Exception {
        MuleSession session = MessageChunkAggregatorTestCase.getTestSession(MessageChunkAggregatorTestCase.getTestService(), muleContext);
        Service testService = MessageChunkAggregatorTestCase.getTestService("test", Apple.class);
        MessageChunkAggregatorTestCase.assertNotNull((Object)testService);
        MessageChunkAggregator router = new MessageChunkAggregator();
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        message1.setCorrelationGroupSize(3);
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, endpoint, session);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, endpoint, session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, endpoint, session);
        MessageChunkAggregatorTestCase.assertNull((Object)router.process((MuleEvent)event1));
        MessageChunkAggregatorTestCase.assertNull((Object)router.process((MuleEvent)event2));
        MuleEvent resultEvent = router.process((MuleEvent)event3);
        MessageChunkAggregatorTestCase.assertNotNull((Object)resultEvent);
        MuleMessage resultMessage = resultEvent.getMessage();
        MessageChunkAggregatorTestCase.assertNotNull((Object)resultMessage);
        String payload = resultMessage.getPayloadAsString();
        MessageChunkAggregatorTestCase.assertEquals((String)"test event Atest event Btest event C", (String)payload);
    }
}

