/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.RoundRobin;
import org.mule.tck.AbstractMuleTestCase;

public class RoundRobinTestCase
extends AbstractMuleTestCase {
    private static final int NUMBER_OF_ROUTES = 10;
    private static final int NUMBER_OF_MESSAGES = 10;
    private final AtomicInteger messageNumber = new AtomicInteger(0);

    public RoundRobinTestCase() {
        this.setStartContext(true);
    }

    public void testRoundRobin() throws Exception {
        RoundRobin rr = new RoundRobin();
        MuleSession session = RoundRobinTestCase.getTestSession(RoundRobinTestCase.getTestService(), muleContext);
        ArrayList<TestProcessor> routes = new ArrayList<TestProcessor>(10);
        for (int i = 0; i < 10; ++i) {
            routes.add(new TestProcessor());
        }
        rr.setMessageProcessors(new ArrayList(routes));
        ArrayList<Thread> threads = new ArrayList<Thread>(10);
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(new TestDriver(session, (MessageProcessor)rr, 10)));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        for (TestProcessor route : routes) {
            RoundRobinTestCase.assertEquals((int)10, (int)route.getCount());
        }
    }

    static class TestProcessor
    implements MessageProcessor {
        private int count;
        private List<Object> payloads = new ArrayList<Object>();

        TestProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.payloads.add(event.getMessage().getPayload());
            ++this.count;
            if (this.count % 3 == 0) {
                throw new DefaultMuleException("Mule Exception!");
            }
            return null;
        }

        public int getCount() {
            return this.count;
        }
    }

    class TestDriver
    implements Runnable {
        private MessageProcessor target;
        private int numMessages;
        private MuleSession session;

        TestDriver(MuleSession session, MessageProcessor target, int numMessages) {
            this.target = target;
            this.numMessages = numMessages;
            this.session = session;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numMessages; ++i) {
                DefaultMuleMessage msg = new DefaultMuleMessage((Object)("Test Message" + RoundRobinTestCase.this.messageNumber.getAndIncrement()), muleContext);
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)msg, MessageExchangePattern.REQUEST_RESPONSE, this.session);
                try {
                    this.target.process((MuleEvent)event);
                    continue;
                }
                catch (MuleException e) {
                    // empty catch block
                }
            }
        }

        private InboundEndpoint createTestEndpoint() {
            try {
                return AbstractMuleTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

