/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ListableObjectStore;
import org.mule.routing.UntilSuccessful;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.store.SimpleMemoryObjectStore;

public class UntilSuccessfulTestCase
extends AbstractMuleTestCase {
    private UntilSuccessful untilSuccessful;
    private ListableObjectStore<MuleEvent> objectStore;
    private ConfigurableMessageProcessor targetMessageProcessor;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.untilSuccessful = new UntilSuccessful();
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.setFlowConstruct((FlowConstruct)UntilSuccessfulTestCase.getTestService());
        this.untilSuccessful.setMaxRetries(2);
        this.untilSuccessful.setSecondsBetweenRetries(1L);
        this.objectStore = new SimpleMemoryObjectStore();
        this.untilSuccessful.setObjectStore(this.objectStore);
        this.targetMessageProcessor = new ConfigurableMessageProcessor();
        this.untilSuccessful.addRoute((MessageProcessor)this.targetMessageProcessor);
    }

    @Override
    protected void doTearDown() throws Exception {
        this.untilSuccessful.stop();
    }

    public void testSuccessfulDelivery() throws Exception {
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        UntilSuccessfulTestCase.assertNull((Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
    }

    public void testSuccessfulDeliveryStreamPayload() throws Exception {
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent(new ByteArrayInputStream("test_data".getBytes()));
        UntilSuccessfulTestCase.assertNull((Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
    }

    public void testSuccessfulDeliveryAckExpression() throws Exception {
        this.untilSuccessful.setAckExpression("#[string:ACK]");
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        UntilSuccessfulTestCase.assertEquals((String)"ACK", (String)this.untilSuccessful.process(testEvent).getMessageAsString());
        this.ponderUntilEventProcessed(testEvent);
    }

    public void testSuccessfulDeliveryFailureExpression() throws Exception {
        this.untilSuccessful.setFailureExpression("#[regex:(?i)error]");
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        UntilSuccessfulTestCase.assertNull((Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
    }

    public void testPermanentDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(Integer.MAX_VALUE);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        UntilSuccessfulTestCase.assertNull((Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
    }

    public void testPermanentDeliveryFailureExpression() throws Exception {
        this.untilSuccessful.setFailureExpression("#[regex:(?i)error]");
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        UntilSuccessfulTestCase.assertNull((Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
    }

    public void testPermanentDeliveryFailureDLQ() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(Integer.MAX_VALUE);
        EndpointBuilder dlqEndpointBuilder = (EndpointBuilder)Mockito.mock(EndpointBuilder.class);
        OutboundEndpoint dlqEndpoint = (OutboundEndpoint)Mockito.mock(OutboundEndpoint.class);
        Mockito.when((Object)dlqEndpointBuilder.buildOutboundEndpoint()).thenReturn((Object)dlqEndpoint);
        this.untilSuccessful.setDlqEndpoint(dlqEndpointBuilder);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        UntilSuccessfulTestCase.assertNull((Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
        ((OutboundEndpoint)Mockito.verify((Object)dlqEndpoint)).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    public void testTemporaryDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(this.untilSuccessful.getMaxRetries());
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        UntilSuccessfulTestCase.assertNull((Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
        UntilSuccessfulTestCase.assertEquals((int)this.targetMessageProcessor.getEventCount(), (int)(this.untilSuccessful.getMaxRetries() + 1));
    }

    public void testPreExistingEvents() throws Exception {
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        this.objectStore.store((Serializable)UntilSuccessful.EventStoreKey.buildFor((MuleEvent)testEvent), (Serializable)testEvent);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        this.ponderUntilEventProcessed(testEvent);
    }

    private void ponderUntilEventProcessed(MuleEvent testEvent) throws InterruptedException, MuleException {
        while (this.targetMessageProcessor.getEventReceived() == null) {
            Thread.yield();
            Thread.sleep(250L);
        }
        UntilSuccessfulTestCase.assertEquals((int)0, (int)this.objectStore.allKeys().size());
        this.assertLogicallyEqualEvents(testEvent, this.targetMessageProcessor.getEventReceived());
    }

    private void ponderUntilEventAborted(MuleEvent testEvent) throws InterruptedException, MuleException {
        while (this.targetMessageProcessor.getEventCount() <= this.untilSuccessful.getMaxRetries()) {
            Thread.yield();
            Thread.sleep(250L);
        }
        UntilSuccessfulTestCase.assertEquals((int)0, (int)this.objectStore.allKeys().size());
        UntilSuccessfulTestCase.assertEquals((int)this.targetMessageProcessor.getEventCount(), (int)(1 + this.untilSuccessful.getMaxRetries()));
    }

    private void assertLogicallyEqualEvents(MuleEvent testEvent, MuleEvent eventReceived) throws MuleException {
        UntilSuccessfulTestCase.assertEquals((String)testEvent.getMessage().getCorrelationId(), (String)eventReceived.getMessage().getCorrelationId());
        UntilSuccessfulTestCase.assertEquals((String)testEvent.getMessageAsString(), (String)eventReceived.getMessageAsString());
    }

    public static class ConfigurableMessageProcessor
    implements MessageProcessor {
        private volatile int eventCount;
        private volatile MuleEvent event;
        private volatile int numberOfFailuresToSimulate;

        public MuleEvent process(MuleEvent event) throws MuleException {
            ++this.eventCount;
            if (this.numberOfFailuresToSimulate-- > 0) {
                throw new RuntimeException("simulated problem");
            }
            this.event = event;
            return event;
        }

        public MuleEvent getEventReceived() {
            return this.event;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public void setNumberOfFailuresToSimulate(int numberOfFailuresToSimulate) {
            this.numberOfFailuresToSimulate = numberOfFailuresToSimulate;
        }
    }
}

