/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.model.Model;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.component.simple.PassThroughComponent;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.AbstractTransformer;

public class DefaultOutboundRouterCollectionTestCase
extends AbstractMuleTestCase {
    private static int LATCH_AWAIT_TIMEOUT_MS = 1000;
    private Service testService;
    private MuleEvent testEvent;
    static MuleMessage originalMessage;
    private TestOutboundRouterCollection outboundRouter;

    public DefaultOutboundRouterCollectionTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.testEvent = DefaultOutboundRouterCollectionTestCase.getTestEvent((Object)"TEST_MESSAGE", DefaultOutboundRouterCollectionTestCase.getTestInboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE));
        this.testService = this.createService();
        this.outboundRouter = new TestOutboundRouterCollection();
        this.testService.setOutboundMessageProcessor((MessageProcessor)this.outboundRouter);
        this.outboundRouter.setMuleContext(muleContext);
        muleContext.getRegistry().registerService(this.testService);
    }

    protected Service createService() throws MuleException {
        SedaModel model = new SedaModel();
        muleContext.getRegistry().registerModel((Model)model);
        SedaService service = new SedaService(muleContext);
        service.setName("test");
        service.setComponent((Component)new PassThroughComponent());
        service.setModel((Model)model);
        return service;
    }

    public void testSingleDoesNotRequireCopyRouterMatchAllFalse() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(false);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testSingleDoesNotRequireCopyRouterMatchAllTrue() throws Exception {
        MuleEvent testEvent = DefaultOutboundRouterCollectionTestCase.getTestEvent("TEST_MESSAGE");
        this.getOutboundRouterCollection().setMatchAll(true);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testSingleRequiresCopyRouterMatchAllFalse() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(false);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testSingleRequiresCopyRouterMatchAllTrue() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(true);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleDoesNotRequireCopyRouterMatchAllFalse() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(false);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleDoesNotRequireCopyRouterMatchAllTrue() throws Exception {
        MuleEvent testEvent = DefaultOutboundRouterCollectionTestCase.getTestEvent("TEST_MESSAGE");
        this.getOutboundRouterCollection().setMatchAll(true);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleRequiresCopyRouterMatchAllFalse() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(false);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleRequiresCopyRouterMatchAllTrue() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(true);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleMixMatchAllTrue() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(true);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(3);
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(2);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleMixMatchAllFalse() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(false);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(true));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await(LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testStreamPayload() throws Exception {
        this.getOutboundRouterCollection().setMatchAll(true);
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        this.getOutboundRouterCollection().addRoute((MatchableMessageProcessor)new TestRequiresNewMessageOutboundRouter(false));
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(2);
        this.testEvent.getMessage().setPayload((Object)new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
            }
        });
        try {
            this.testService.sendEvent(this.testEvent);
            DefaultOutboundRouterCollectionTestCase.fail((String)"Exception was expected");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private OutboundRouterCollection getOutboundRouterCollection() {
        return (OutboundRouterCollection)this.testService.getOutboundMessageProcessor();
    }

    private static class TestOutboundRouterCollection
    extends DefaultOutboundRouterCollection {
        public MuleEvent process(MuleEvent event) throws MessagingException {
            originalMessage = event.getMessage();
            return super.process(event);
        }
    }

    private static class TestDoesNotRequireNewMessageOutboundRouter
    extends OutboundPassThroughRouter {
        static CountDownLatch latch;
        private boolean expectCopy;

        public TestDoesNotRequireNewMessageOutboundRouter(boolean expectCopy) {
            this.expectCopy = expectCopy;
        }

        public List<MessageProcessor> getRoutes() {
            ArrayList<MessageProcessor> list = new ArrayList<MessageProcessor>();
            try {
                list.add((MessageProcessor)AbstractMuleTestCase.getTestOutboundEndpoint("out", "test://out"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            return list;
        }

        public boolean isMatch(MuleMessage message) throws MuleException {
            if (this.expectCopy) {
                Assert.assertNotSame((Object)originalMessage, (Object)message);
            } else {
                Assert.assertSame((Object)originalMessage, (Object)message);
            }
            latch.countDown();
            return false;
        }
    }

    private static class TestRequiresNewMessageOutboundRouter
    extends OutboundPassThroughRouter {
        static CountDownLatch latch;
        private boolean expectCopy;

        public TestRequiresNewMessageOutboundRouter(boolean expectCopy) {
            this.expectCopy = expectCopy;
            ArrayList<1> transformers = new ArrayList<1>();
            transformers.add(new AbstractTransformer(){

                public Object doTransform(Object src, String encoding) throws TransformerException {
                    return src;
                }
            });
            this.setTransformers(transformers);
        }

        public List<MessageProcessor> getRoutes() {
            ArrayList<MessageProcessor> list = new ArrayList<MessageProcessor>();
            try {
                list.add((MessageProcessor)AbstractMuleTestCase.getTestOutboundEndpoint("out", "test://out"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            return list;
        }

        public boolean isMatch(MuleMessage message) throws MuleException {
            if (this.expectCopy) {
                Assert.assertNotSame((Object)originalMessage, (Object)message);
            } else {
                Assert.assertSame((Object)originalMessage, (Object)message);
            }
            latch.countDown();
            return false;
        }
    }
}

