/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ListMessageSplitter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class FilterListMessageSplitterRouterTestCase
extends AbstractMuleTestCase {
    public FilterListMessageSplitterRouterTestCase() {
        this.setStartContext(true);
    }

    public void testMessageSplitterRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)FilterListMessageSplitterRouterTestCase.getTestService());
        session.matchAndReturn("setFlowConstruct", (ConstraintMatcher)RouterTestUtils.getArgListCheckerFlowConstruct(), null);
        OutboundEndpoint endpoint1 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint endpoint2 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint endpoint3 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        Mock mockendpoint3 = RouterTestUtils.getMockEndpoint(endpoint3);
        ListMessageSplitter router = this.createObject(ListMessageSplitter.class);
        router.setFilter((Filter)new PayloadTypeFilter(List.class));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint1.proxy()));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint2.proxy()));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint3.proxy()));
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(new Apple());
        payload.add(new Apple());
        payload.add(new Orange());
        payload.add(new String());
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        FilterListMessageSplitterRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        mockendpoint1.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint1.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint2.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint3.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy(), muleContext));
        mockendpoint1.verify();
        mockendpoint2.verify();
        mockendpoint3.verify();
        endpoint1 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        endpoint2 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        endpoint3 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3?exchangePattern=request-response");
        mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        mockendpoint3 = RouterTestUtils.getMockEndpoint(endpoint3);
        router = this.createObject(ListMessageSplitter.class);
        router.setFilter((Filter)new PayloadTypeFilter(List.class));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint1.proxy()));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint2.proxy()));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint3.proxy()));
        message = new DefaultMuleMessage(payload, muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint3.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy(), muleContext));
        FilterListMessageSplitterRouterTestCase.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        FilterListMessageSplitterRouterTestCase.assertNotNull((Object)resultMessage);
        FilterListMessageSplitterRouterTestCase.assertTrue((boolean)(resultMessage.getPayload() instanceof List));
        FilterListMessageSplitterRouterTestCase.assertEquals((int)((List)resultMessage.getPayload()).size(), (int)4);
        mockendpoint1.verify();
        mockendpoint2.verify();
        mockendpoint3.verify();
    }
}

