/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.requestreply;

import java.beans.ExceptionListener;
import javax.resource.spi.work.Work;
import junit.framework.Assert;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.RequestReplyRequesterMessageProcessor;
import org.mule.api.routing.ResponseTimeoutException;
import org.mule.api.service.Service;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.routing.requestreply.AbstractAsyncRequestReplyRequester;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.SensingNullMessageProcessor;

public class AsyncRequestReplyRequesterTestCase
extends AbstractMuleTestCase
implements ExceptionListener {
    public void testSingleEventNoTimeout() throws Exception {
        TestAsyncRequestReplyRequester asyncReplyMP = new TestAsyncRequestReplyRequester();
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        asyncReplyMP.setListener(target);
        asyncReplyMP.setReplySource(target.getMessageSource());
        MuleEvent event = AsyncRequestReplyRequesterTestCase.getTestEvent((Object)"Test Message", AsyncRequestReplyRequesterTestCase.getTestService());
        MuleEvent resultEvent = asyncReplyMP.process(event);
        AsyncRequestReplyRequesterTestCase.assertEquals((String)event.getMessageAsString(), (String)resultEvent.getMessageAsString());
        AsyncRequestReplyRequesterTestCase.assertEquals((String)event.getMessage().getUniqueId(), (String)resultEvent.getMessage().getUniqueId());
    }

    public void testSingleEventNoTimeoutAsync() throws Exception {
        TestAsyncRequestReplyRequester asyncReplyMP = new TestAsyncRequestReplyRequester();
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        AsyncInterceptingMessageProcessor asyncMP = new AsyncInterceptingMessageProcessor(new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return muleContext.getWorkManager();
            }
        }, true);
        asyncMP.setListener((MessageProcessor)target);
        asyncReplyMP.setListener((MessageProcessor)asyncMP);
        asyncReplyMP.setReplySource(target.getMessageSource());
        MuleEvent event = AsyncRequestReplyRequesterTestCase.getTestEvent((Object)"Test Message", AsyncRequestReplyRequesterTestCase.getTestService(), AsyncRequestReplyRequesterTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        MuleEvent resultEvent = asyncReplyMP.process(event);
        AsyncRequestReplyRequesterTestCase.assertEquals((String)event.getMessageAsString(), (String)resultEvent.getMessageAsString());
        AsyncRequestReplyRequesterTestCase.assertEquals((String)event.getMessage().getUniqueId(), (String)resultEvent.getMessage().getUniqueId());
    }

    public void testSingleEventTimeout() throws Exception {
        TestAsyncRequestReplyRequester asyncReplyMP = new TestAsyncRequestReplyRequester();
        asyncReplyMP.setTimeout(1L);
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        target.setWaitTime(50L);
        AsyncInterceptingMessageProcessor asyncMP = new AsyncInterceptingMessageProcessor(new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return muleContext.getWorkManager();
            }
        }, true);
        asyncMP.setListener((MessageProcessor)target);
        asyncReplyMP.setListener((MessageProcessor)asyncMP);
        asyncReplyMP.setReplySource(target.getMessageSource());
        MuleEvent event = AsyncRequestReplyRequesterTestCase.getTestEvent((Object)"Test Message", AsyncRequestReplyRequesterTestCase.getTestService(), AsyncRequestReplyRequesterTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        try {
            asyncReplyMP.process(event);
            AsyncRequestReplyRequesterTestCase.fail((String)"ResponseTimeoutException expected");
        }
        catch (Exception e) {
            AsyncRequestReplyRequesterTestCase.assertEquals(ResponseTimeoutException.class, e.getClass());
        }
    }

    public void testMultiple() throws Exception {
        TestAsyncRequestReplyRequester asyncReplyMP = new TestAsyncRequestReplyRequester();
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        target.setWaitTime(50L);
        AsyncInterceptingMessageProcessor asyncMP = new AsyncInterceptingMessageProcessor(new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return muleContext.getWorkManager();
            }
        }, true);
        asyncMP.setListener((MessageProcessor)target);
        asyncReplyMP.setListener((MessageProcessor)asyncMP);
        asyncReplyMP.setReplySource(target.getMessageSource());
        final InboundEndpoint inboundEndpoint = AsyncRequestReplyRequesterTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY);
        final Service service = AsyncRequestReplyRequesterTestCase.getTestService();
        for (int i = 0; i < 500; ++i) {
            muleContext.getWorkManager().scheduleWork(new Work((RequestReplyRequesterMessageProcessor)asyncReplyMP){
                final /* synthetic */ RequestReplyRequesterMessageProcessor val$asyncReplyMP;
                {
                    this.val$asyncReplyMP = requestReplyRequesterMessageProcessor;
                }

                public void run() {
                    try {
                        MuleEvent event = AbstractMuleTestCase.getTestEvent((Object)"Test Message", service, inboundEndpoint);
                        MuleEvent resultEvent = this.val$asyncReplyMP.process(event);
                        Assert.assertEquals((String)event.getMessageAsString(), (String)resultEvent.getMessageAsString());
                        Assert.assertEquals((String)event.getMessage().getUniqueId(), (String)resultEvent.getMessage().getUniqueId());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void release() {
                }
            });
        }
    }

    @Override
    public void exceptionThrown(Exception e) {
        e.printStackTrace();
        AsyncRequestReplyRequesterTestCase.fail((String)e.getMessage());
    }

    class TestAsyncRequestReplyRequester
    extends AbstractAsyncRequestReplyRequester {
        TestAsyncRequestReplyRequester() {
        }
    }
}

