/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreePortFinder {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final int minPortNumber;
    protected final int maxPortNumber;
    private Set<Integer> selectedPorts = new HashSet<Integer>();

    public FreePortFinder(int minPortNumber, int maxPortNumber) {
        this.minPortNumber = minPortNumber;
        this.maxPortNumber = maxPortNumber;
    }

    public synchronized Integer find() {
        for (int port = this.minPortNumber; port < this.maxPortNumber; ++port) {
            if (this.selectedPorts.contains(port) || !this.isPortFree(port)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found free port: " + port));
            }
            this.selectedPorts.add(port);
            return port;
        }
        throw new IllegalStateException("Unable to find an available port");
    }

    public synchronized void releasePort(int port) {
        if (this.isPortFree(port)) {
            this.selectedPorts.remove(port);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Port %d was is not correctly released", port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortFree(int port) {
        boolean portIsFree = true;
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
        }
        catch (IOException e) {
            portIsFree = false;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException e) {}
            }
        }
        return portIsFree;
    }
}

