/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.api.transaction.TransactionException;
import org.mule.context.notification.TransactionNotification;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transaction.AbstractSingleResourceTransaction;

public class TransactionNotificationsTestCase
extends AbstractMuleTestCase {
    public void testTransactionNotifications() throws Exception {
        final CountDownLatch latch = new CountDownLatch(3);
        DummyTransaction transaction = new DummyTransaction(muleContext);
        muleContext.registerListener((ServerNotificationListener)new TransactionNotificationListener<TransactionNotification>(){

            public void onNotification(TransactionNotification notification) {
                if (notification.getAction() == 1201) {
                    Assert.assertEquals((String)"begin", (String)notification.getActionName());
                    latch.countDown();
                } else if (notification.getAction() == 1202) {
                    Assert.assertEquals((String)"commit", (String)notification.getActionName());
                    latch.countDown();
                } else if (notification.getAction() == 1203) {
                    Assert.assertEquals((String)"rollback", (String)notification.getActionName());
                    latch.countDown();
                }
            }
        }, transaction.getId());
        transaction.begin();
        transaction.commit();
        transaction.rollback();
        latch.await(2000L, TimeUnit.MILLISECONDS);
        TransactionNotificationsTestCase.assertEquals((String)"There are still some notifications left unfired.", (long)0L, (long)latch.getCount());
    }

    private class DummyTransaction
    extends AbstractSingleResourceTransaction {
        private DummyTransaction(MuleContext muleContext) {
            super(muleContext);
        }

        protected void doBegin() throws TransactionException {
        }

        protected void doCommit() throws TransactionException {
        }

        protected void doRollback() throws TransactionException {
        }
    }
}

