/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mule.api.transformer.DataType;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.types.CollectionDataType;
import org.mule.transformer.types.DataTypeFactory;

public class DataTypesTestCase
extends AbstractMuleTestCase {
    private List<Exception> listOfExceptions;

    public void testSimpleTypes() throws Exception {
        DataType dt = DataTypeFactory.create(Exception.class);
        DataType dt2 = DataTypeFactory.create(Exception.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = DataTypeFactory.create(IOException.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt2 = DataTypeFactory.create(IOException.class, (String)"application/exception+java");
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt.setMimeType("application/octet-stream");
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt = DataTypeFactory.create(Exception.class);
        dt2 = DataTypeFactory.STRING;
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testCollectionTypes() throws Exception {
        DataType dt = DataTypeFactory.create(List.class);
        DataType dt2 = DataTypeFactory.create(List.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = DataTypeFactory.create(ArrayList.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt2 = DataTypeFactory.create(ArrayList.class, (String)"application/list+java");
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt.setMimeType("application/octet-stream");
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt = DataTypeFactory.create(List.class);
        dt2 = DataTypeFactory.create(Set.class);
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypes() throws Exception {
        DataType dt = DataTypeFactory.create(List.class, Exception.class);
        DataType dt2 = DataTypeFactory.create(List.class, Exception.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = DataTypeFactory.create(ArrayList.class, IOException.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt2 = DataTypeFactory.create(ArrayList.class, IOException.class, (String)"application/list+java");
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt.setMimeType("application/octet-stream");
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt = DataTypeFactory.create(List.class, Exception.class);
        dt2 = DataTypeFactory.create(List.class, String.class);
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypesFromMethodReturn() throws Exception {
        DataType dt = DataTypeFactory.createFromReturnType((Method)this.getClass().getDeclaredMethod("listOfExceptionsMethod", String.class));
        DataTypesTestCase.assertTrue((boolean)(dt instanceof CollectionDataType));
        DataTypesTestCase.assertEquals(List.class, (Object)dt.getType());
        DataTypesTestCase.assertEquals(Exception.class, (Object)((CollectionDataType)dt).getItemType());
        DataType dt2 = DataTypeFactory.createFromReturnType((Method)this.getClass().getDeclaredMethod("listOfExceptionsMethod", String.class));
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = DataTypeFactory.createFromReturnType((Method)this.getClass().getDeclaredMethod("listOfExceptionsMethod", Integer.class));
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypesFromMethodParam() throws Exception {
        DataType dt = DataTypeFactory.createFromParameterType((Method)this.getClass().getDeclaredMethod("listOfExceptionsMethod", Collection.class), (int)0);
        DataTypesTestCase.assertTrue((boolean)(dt instanceof CollectionDataType));
        DataTypesTestCase.assertEquals(Collection.class, (Object)dt.getType());
        DataTypesTestCase.assertEquals(Exception.class, (Object)((CollectionDataType)dt).getItemType());
        DataType dt2 = DataTypeFactory.createFromParameterType((Method)this.getClass().getDeclaredMethod("listOfExceptionsMethod", Collection.class), (int)0);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = DataTypeFactory.createFromParameterType((Method)this.getClass().getDeclaredMethod("listOfExceptionsMethod", List.class), (int)0);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypesFromField() throws Exception {
        DataType dt = DataTypeFactory.createFromField((Field)this.getClass().getDeclaredField("listOfExceptions"));
        DataTypesTestCase.assertTrue((boolean)(dt instanceof CollectionDataType));
        DataTypesTestCase.assertEquals(List.class, (Object)dt.getType());
        DataTypesTestCase.assertEquals(Exception.class, (Object)((CollectionDataType)dt).getItemType());
    }

    private List<Exception> listOfExceptionsMethod(String s) {
        return null;
    }

    private ArrayList<IOException> listOfExceptionsMethod(Integer i) {
        return null;
    }

    private String listOfExceptionsMethod(Collection<Exception> exceptions) {
        return null;
    }

    private Integer listOfExceptionsMethod(List<IOException> ioExceptions) {
        return null;
    }
}

