/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import junit.framework.Assert;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MessageRequester;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractMessageRequester;

public class ConnectorLifecycleTestCase
extends AbstractMuleTestCase {
    private TestConnector connector;

    @Override
    public void doSetUp() throws Exception {
        this.connector = new TestConnector(muleContext);
        this.connector.initialise();
    }

    @Override
    public void doTearDown() throws Exception {
        if (!this.connector.isDisposed()) {
            this.connector.dispose();
        }
        this.connector = null;
    }

    public void testDoubleInitialiseConnector() throws Exception {
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        try {
            this.connector.initialise();
            Assert.fail((String)"Expected IllegalStateException not thrown.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testDoubleStartConnector() throws Exception {
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        try {
            this.connector.start();
            ConnectorLifecycleTestCase.fail((String)"cannot start the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
    }

    public void testDoubleStopConnector() throws Exception {
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        try {
            this.connector.stop();
            ConnectorLifecycleTestCase.fail((String)"cannot stop the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.connector.disconnect();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnectorStartStop() throws Exception {
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.isStarted());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        try {
            this.connector.dispose();
            ConnectorLifecycleTestCase.fail((String)"cannot dispose the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnectorStartOnly() throws Exception {
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        try {
            this.connector.dispose();
            ConnectorLifecycleTestCase.fail((String)"cannot dispose the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnector() throws Exception {
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        try {
            this.connector.dispose();
            ConnectorLifecycleTestCase.fail((String)"cannot dispose the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testReceiversLifecycle() throws Exception {
        Service service = ConnectorLifecycleTestCase.getTestService();
        service.start();
        this.connector.registerListener(ConnectorLifecycleTestCase.getTestInboundEndpoint("in", "test://in"), this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.registerListener(ConnectorLifecycleTestCase.getTestInboundEndpoint("in2", "test://in2"), this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in2")).isStarted());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in2")).isStarted());
        this.connector.disconnect();
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in2")).isStarted());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.receivers.size());
    }

    public void testReceiversServiceLifecycle() throws Exception {
        Service service = ConnectorLifecycleTestCase.getTestService();
        InboundEndpoint endpoint = ConnectorLifecycleTestCase.getTestInboundEndpoint("in", "test://in");
        ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)endpoint);
        this.connector = (TestConnector)endpoint.getConnector();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.receivers.size());
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.receivers.size());
        service.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.disconnect();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        service.stop();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.receivers.size());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.receivers.size());
    }

    public void testDispatchersLifecycle() throws Exception {
        OutboundEndpoint out = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out", "test://out?exchangePattern=request-response", null, null, null, (Connector)this.connector);
        try {
            out.process(ConnectorLifecycleTestCase.getTestEvent("data"));
            ConnectorLifecycleTestCase.fail((String)"cannot send on a connector that is not started");
        }
        catch (LifecycleException e) {
            // empty catch block
        }
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConnected(out, false, false);
        this.connector.start();
        this.assertDispatcherStartedConnected(out, true, true);
        OutboundEndpoint out2 = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out2", "test://out2?exchangePattern=request-response", null, null, null, (Connector)this.connector);
        out2.process(ConnectorLifecycleTestCase.getTestEvent("data"));
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConnected(out, true, true);
        this.assertDispatcherStartedConnected(out2, true, true);
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
        this.assertDispatcherStartedConnected(out, false, false);
        this.assertDispatcherStartedConnected(out2, false, false);
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
        this.assertDispatcherStartedConnected(out, true, true);
        this.assertDispatcherStartedConnected(out2, true, true);
        out.process(ConnectorLifecycleTestCase.getTestEvent("data"));
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConnected(out, true, true);
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
    }

    public void testDispatcherFullLifecycle() throws Exception {
        OutboundEndpoint out = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out", "test://out", null, null, null, (Connector)this.connector);
        MessageDispatcher dispatcher = this.connector.getDispatcherFactory().create(out);
        dispatcher.initialise();
        ConnectorLifecycleTestCase.assertTrue((boolean)dispatcher.getLifecycleState().isInitialised());
        dispatcher.connect();
        ConnectorLifecycleTestCase.assertTrue((boolean)dispatcher.isConnected());
        dispatcher.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)dispatcher.getLifecycleState().isStarted());
        dispatcher.stop();
        ConnectorLifecycleTestCase.assertTrue((boolean)dispatcher.getLifecycleState().isStopped());
        dispatcher.disconnect();
        ConnectorLifecycleTestCase.assertFalse((boolean)dispatcher.isConnected());
        dispatcher.dispose();
        ConnectorLifecycleTestCase.assertTrue((boolean)dispatcher.getLifecycleState().isDisposed());
    }

    public void testRequestersLifecycle() throws Exception {
        InboundEndpoint in = ConnectorLifecycleTestCase.getTestInboundEndpoint("in", "test://in", null, null, null, (Connector)this.connector);
        try {
            in.request(1000L);
            ConnectorLifecycleTestCase.fail((String)"cannot sent on a connector that is not started");
        }
        catch (LifecycleException e) {
            // empty catch block
        }
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.requesters.getNumIdle());
        this.assertRequesterStartedConnected(in, false, false);
        this.connector.start();
        this.assertRequesterStartedConnected(in, true, true);
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.requesters.getNumIdle());
        InboundEndpoint in2 = ConnectorLifecycleTestCase.getTestInboundEndpoint("in2", "test://in2", null, null, null, (Connector)this.connector);
        in2.request(1000L);
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.requesters.getNumIdle());
        this.assertRequesterStartedConnected(in, true, true);
        this.assertRequesterStartedConnected(in2, true, true);
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)(this.connector.requesters.getNumActive() + this.connector.requesters.getNumIdle()));
        this.assertRequesterStartedConnected(in, false, false);
        this.assertRequesterStartedConnected(in2, false, false);
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)(this.connector.requesters.getNumActive() + this.connector.requesters.getNumIdle()));
        this.assertRequesterStartedConnected(in, true, true);
        this.assertRequesterStartedConnected(in2, true, true);
        in.request(1000L);
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.requesters.getNumIdle());
        this.assertRequesterStartedConnected(in, true, true);
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)(this.connector.requesters.getNumActive() + this.connector.requesters.getNumIdle()));
    }

    public void testRequesterFullLifecycle() throws Exception {
        InboundEndpoint in = ConnectorLifecycleTestCase.getTestInboundEndpoint("out", "test://out", null, null, null, (Connector)this.connector);
        MessageRequester requester = this.connector.getRequesterFactory().create(in);
        requester.initialise();
        ConnectorLifecycleTestCase.assertTrue((boolean)requester.getLifecycleState().isInitialised());
        requester.connect();
        ConnectorLifecycleTestCase.assertTrue((boolean)requester.isConnected());
        requester.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)requester.getLifecycleState().isStarted());
        requester.stop();
        ConnectorLifecycleTestCase.assertTrue((boolean)requester.getLifecycleState().isStopped());
        requester.disconnect();
        ConnectorLifecycleTestCase.assertFalse((boolean)requester.isConnected());
        requester.dispose();
        ConnectorLifecycleTestCase.assertTrue((boolean)requester.getLifecycleState().isDisposed());
    }

    public void testWorkManagerLifecycle() throws MuleException, WorkException {
        this.connector.start();
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getReceiverWorkManager());
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getRequesterWorkManager());
        this.connector.getReceiverWorkManager().doWork(this.createSomeWork());
        this.connector.getDispatcherWorkManager().doWork(this.createSomeWork());
        this.connector.getRequesterWorkManager().doWork(this.createSomeWork());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getReceiverWorkManager());
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getRequesterWorkManager());
        this.connector.start();
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getReceiverWorkManager());
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getRequesterWorkManager());
        this.connector.getReceiverWorkManager().doWork(this.createSomeWork());
        this.connector.getDispatcherWorkManager().doWork(this.createSomeWork());
        this.connector.getRequesterWorkManager().doWork(this.createSomeWork());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getReceiverWorkManager());
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getRequesterWorkManager());
    }

    public void testSchedulerLifecycle() throws MuleException, WorkException {
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getScheduler());
        this.connector.start();
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isShutdown());
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isTerminated());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getScheduler());
        this.connector.start();
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isShutdown());
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isTerminated());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getScheduler());
    }

    protected Work createSomeWork() {
        return new Work(){

            public void run() {
                System.out.println("I'm doing some work");
            }

            public void release() {
            }
        };
    }

    private void assertDispatcherStartedConnected(OutboundEndpoint out, boolean started, boolean connected) throws Exception {
        AbstractMessageDispatcher dispatcher = (AbstractMessageDispatcher)this.connector.dispatchers.borrowObject((Object)out);
        ConnectorLifecycleTestCase.assertEquals((String)"Dispatcher started", (boolean)started, (boolean)dispatcher.isStarted());
        ConnectorLifecycleTestCase.assertEquals((String)"Dispatcher connected", (boolean)connected, (boolean)dispatcher.isConnected());
        this.connector.dispatchers.returnObject((Object)out, (Object)dispatcher);
    }

    private void assertRequesterStartedConnected(InboundEndpoint in, boolean started, boolean connected) throws Exception {
        AbstractMessageRequester requester = (AbstractMessageRequester)this.connector.requesters.borrowObject((Object)in);
        ConnectorLifecycleTestCase.assertEquals((String)"Requester started", (boolean)started, (boolean)requester.isStarted());
        ConnectorLifecycleTestCase.assertEquals((String)"requester connected", (boolean)connected, (boolean)requester.isConnected());
        this.connector.requesters.returnObject((Object)in, (Object)requester);
    }
}

