/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.AbstractFruit;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;
import org.mule.util.ClassUtils;

public class ClassUtilsTestCase
extends AbstractMuleTestCase {
    protected final Set<String> ignoreMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler"));

    public void testIsConcrete() throws Exception {
        ClassUtilsTestCase.assertTrue((boolean)ClassUtils.isConcrete(Orange.class));
        ClassUtilsTestCase.assertTrue((!ClassUtils.isConcrete(Fruit.class) ? 1 : 0) != 0);
        ClassUtilsTestCase.assertTrue((!ClassUtils.isConcrete(AbstractFruit.class) ? 1 : 0) != 0);
        try {
            ClassUtils.isConcrete(null);
            ClassUtilsTestCase.fail((String)"Class cannot be null, exception should be thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testLoadClass() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.String", this.getClass());
        ClassUtilsTestCase.assertNotNull((Object)clazz);
        ClassUtilsTestCase.assertEquals((String)clazz.getName(), (String)"java.lang.String");
        try {
            ClassUtils.loadClass((String)"java.lang.Bing", this.getClass());
            ClassUtilsTestCase.fail((String)"ClassNotFoundException should be thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void testLoadPrimitiveClass() throws Exception {
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"boolean", this.getClass()), Boolean.TYPE);
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"byte", this.getClass()), Byte.TYPE);
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"char", this.getClass()), Character.TYPE);
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"double", this.getClass()), Double.TYPE);
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"float", this.getClass()), Float.TYPE);
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"int", this.getClass()), Integer.TYPE);
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"long", this.getClass()), Long.TYPE);
        ClassUtilsTestCase.assertSame((Object)ClassUtils.loadClass((String)"short", this.getClass()), Short.TYPE);
    }

    public void testLoadClassOfType() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.IllegalArgumentException", this.getClass(), Exception.class);
        ClassUtilsTestCase.assertNotNull((Object)clazz);
        ClassUtilsTestCase.assertEquals((String)clazz.getName(), (String)"java.lang.IllegalArgumentException");
        try {
            ClassUtils.loadClass((String)"java.lang.UnsupportedOperationException", this.getClass(), String.class);
            ClassUtilsTestCase.fail((String)"IllegalArgumentException should be thrown since class is not of expected type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInstanciateClass() throws Exception {
        Object object = ClassUtils.instanciateClass((String)"org.mule.tck.testmodels.fruit.Orange", (Object[])new Object[0]);
        ClassUtilsTestCase.assertNotNull((Object)object);
        ClassUtilsTestCase.assertTrue((boolean)(object instanceof Orange));
        object = ClassUtils.instanciateClass((String)"org.mule.tck.testmodels.fruit.FruitBowl", (Object[])new Object[]{new Apple(), new Banana()});
        ClassUtilsTestCase.assertNotNull((Object)object);
        ClassUtilsTestCase.assertTrue((boolean)(object instanceof FruitBowl));
        FruitBowl bowl = (FruitBowl)object;
        ClassUtilsTestCase.assertTrue((boolean)bowl.hasApple());
        ClassUtilsTestCase.assertTrue((boolean)bowl.hasBanana());
        try {
            ClassUtils.instanciateClass((String)"java.lang.Bing", (Object[])new Object[0]);
            ClassUtilsTestCase.fail((String)"Class does not exist, ClassNotFoundException should have been thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void testGetParameterTypes() throws Exception {
        FruitBowl bowl = new FruitBowl();
        Class[] classes = ClassUtils.getParameterTypes((Object)bowl, (String)"apple");
        ClassUtilsTestCase.assertNotNull((Object)classes);
        ClassUtilsTestCase.assertEquals((int)1, (int)classes.length);
        ClassUtilsTestCase.assertEquals(Apple.class, (Object)classes[0]);
        classes = ClassUtils.getParameterTypes((Object)bowl, (String)"invalid");
        ClassUtilsTestCase.assertNotNull((Object)classes);
        ClassUtilsTestCase.assertEquals((int)0, (int)classes.length);
    }

    public void testLoadingResources() throws Exception {
        URL resource = ClassUtils.getResource((String)"log4j.properties", this.getClass());
        ClassUtilsTestCase.assertNotNull((Object)resource);
        resource = ClassUtils.getResource((String)"does-not-exist.properties", this.getClass());
        ClassUtilsTestCase.assertNull((Object)resource);
    }

    public void testLoadingResourceEnumeration() throws Exception {
        Enumeration enumeration = ClassUtils.getResources((String)"log4j.properties", this.getClass());
        ClassUtilsTestCase.assertNotNull((Object)enumeration);
        ClassUtilsTestCase.assertTrue((boolean)enumeration.hasMoreElements());
        enumeration = ClassUtils.getResources((String)"does-not-exist.properties", this.getClass());
        ClassUtilsTestCase.assertNotNull((Object)enumeration);
        ClassUtilsTestCase.assertTrue((!enumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    public void testGetSatisfiableMethods() throws Exception {
        List methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{Apple.class}, (boolean)true, (boolean)true, this.ignoreMethods);
        ClassUtilsTestCase.assertNotNull((Object)methods);
        ClassUtilsTestCase.assertEquals((int)2, (int)methods.size());
        methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{Apple.class}, (boolean)false, (boolean)true, this.ignoreMethods);
        ClassUtilsTestCase.assertNotNull((Object)methods);
        ClassUtilsTestCase.assertEquals((int)0, (int)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)true, (boolean)false, this.ignoreMethods);
        ClassUtilsTestCase.assertNotNull((Object)methods);
        ClassUtilsTestCase.assertEquals((int)0, (int)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)true, (boolean)true, this.ignoreMethods);
        ClassUtilsTestCase.assertNotNull((Object)methods);
        ClassUtilsTestCase.assertEquals((int)2, (int)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)false, (boolean)true, this.ignoreMethods);
        ClassUtilsTestCase.assertNotNull((Object)methods);
        ClassUtilsTestCase.assertEquals((int)1, (int)methods.size());
        ClassUtilsTestCase.assertEquals((String)"doSomethingElse", (String)((Method)methods.get(0)).getName());
        methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{WaterMelon[].class}, (boolean)true, (boolean)true, this.ignoreMethods);
        ClassUtilsTestCase.assertNotNull((Object)methods);
        ClassUtilsTestCase.assertEquals((int)1, (int)methods.size());
        ClassUtilsTestCase.assertEquals((String)"setFruit", (String)((Method)methods.get(0)).getName());
    }

    public void testSimpleName() {
        this.simpleNameHelper("String", "foo".getClass());
        this.simpleNameHelper("int[]", new int[0].getClass());
        this.simpleNameHelper("Object[][]", new Object[0][0].getClass());
        this.simpleNameHelper("null", null);
    }

    public void testEqual() {
        HashBlob a1 = new HashBlob(1);
        HashBlob a2 = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        ClassUtilsTestCase.assertTrue((boolean)ClassUtils.equal((Object)a1, (Object)a2));
        ClassUtilsTestCase.assertTrue((boolean)ClassUtils.equal((Object)b, (Object)b));
        ClassUtilsTestCase.assertTrue((boolean)ClassUtils.equal(null, null));
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.equal((Object)a1, (Object)b));
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.equal((Object)a2, (Object)b));
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.equal(null, (Object)b));
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.equal((Object)b, (Object)a1));
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.equal((Object)b, (Object)a2));
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.equal((Object)b, null));
    }

    public void testHash() {
        HashBlob a = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        ClassUtilsTestCase.assertTrue((ClassUtils.hash((Object[])new Object[]{a, b, a, b}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        ClassUtilsTestCase.assertFalse((ClassUtils.hash((Object[])new Object[]{a, b, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        ClassUtilsTestCase.assertFalse((ClassUtils.hash((Object[])new Object[]{a, b, a, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        ClassUtilsTestCase.assertFalse((ClassUtils.hash((Object[])new Object[]{b, a, b, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
    }

    public void testClassTypesWithNullInArray() {
        Object[] array = new Object[]{"hello", null, "world"};
        Class[] classTypes = ClassUtils.getClassTypes((Object)array);
        ClassUtilsTestCase.assertEquals((int)3, (int)classTypes.length);
        ClassUtilsTestCase.assertEquals(String.class, (Object)classTypes[0]);
        ClassUtilsTestCase.assertEquals(null, (Object)classTypes[1]);
        ClassUtilsTestCase.assertEquals(String.class, (Object)classTypes[2]);
    }

    public void testCompareWithNull() {
        Class[] c1 = new Class[]{String.class, Integer.class};
        Class[] c2 = new Class[]{String.class, null};
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.compare((Class[])c1, (Class[])c2, (boolean)true));
        ClassUtilsTestCase.assertFalse((boolean)ClassUtils.compare((Class[])c2, (Class[])c1, (boolean)true));
    }

    private void simpleNameHelper(String target, Class clazz) {
        ClassUtilsTestCase.assertEquals((String)target, (String)ClassUtils.getSimpleName((Class)clazz));
    }

    private static class HashBlob {
        private int hash;

        public HashBlob(int hash) {
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (null == other || !this.getClass().equals(other.getClass())) {
                return false;
            }
            return this.hash == ((HashBlob)other).hash;
        }
    }

    private static class DummyObject {
        private DummyObject() {
        }

        public void doSomething(Object object) {
        }

        public Object doSomethingElse(Object object) {
            return object;
        }
    }
}

