/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.ExceptionCollectingThreadGroup;
import org.mule.util.concurrent.LastRejectedWaitPolicy;
import org.mule.util.concurrent.SleepyTask;

public class WaitPolicyTestCase
extends AbstractMuleTestCase {
    private ExceptionCollectingThreadGroup threadGroup;
    ThreadPoolExecutor executor;
    ReentrantLock executorLock;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.executor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1));
        this.executor.prestartAllCoreThreads();
        this.executorLock = new ReentrantLock(true);
        this.threadGroup = new ExceptionCollectingThreadGroup();
        SleepyTask.activeTasks.set(0);
    }

    @Override
    protected void doTearDown() throws Exception {
        this.executor.shutdown();
        this.threadGroup.destroy();
        super.doTearDown();
    }

    protected LinkedList<Thread> execute(List<Runnable> tasks) throws InterruptedException {
        if (tasks == null || tasks.isEmpty()) {
            throw new IllegalArgumentException("List<Runnable> must not be empty");
        }
        LinkedList<Thread> submitters = new LinkedList<Thread>();
        this.executorLock.lock();
        for (final Runnable task : tasks) {
            Runnable submitterAction = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WaitPolicyTestCase.this.executorLock.lock();
                        WaitPolicyTestCase.this.executor.execute(task);
                    }
                    finally {
                        WaitPolicyTestCase.this.executorLock.unlock();
                    }
                }
            };
            Thread submitter = new Thread((ThreadGroup)this.threadGroup, submitterAction);
            submitter.setDaemon(true);
            submitters.add(submitter);
            submitter.start();
            while (submitter.isAlive() && !this.executorLock.hasQueuedThread(submitter)) {
                Thread.sleep(10L);
            }
        }
        this.executorLock.unlock();
        return submitters;
    }

    public void testWaitPolicyWithShutdownExecutor() throws Exception {
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)new LastRejectedWaitPolicy()));
        this.executor.shutdown();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("rejected", 1000L));
        LinkedList<Thread> submitters = this.execute(tasks);
        WaitPolicyTestCase.assertFalse((boolean)submitters.isEmpty());
        Thread.sleep(1000L);
        LinkedList<Map<Thread, Throwable>> exceptions = this.threadGroup.collectedExceptions();
        WaitPolicyTestCase.assertEquals((int)1, (int)exceptions.size());
        Map.Entry<Thread, Throwable> threadFailure = exceptions.getFirst().entrySet().iterator().next();
        WaitPolicyTestCase.assertEquals((Object)submitters.getFirst(), (Object)threadFailure.getKey());
        WaitPolicyTestCase.assertEquals(RejectedExecutionException.class, threadFailure.getValue().getClass());
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
    }

    public void testWaitPolicyForever() throws Exception {
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(-1L, TimeUnit.SECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask waiting = new SleepyTask("waitingForever", 1000L);
        tasks.add(waiting);
        LinkedList<Thread> submitters = this.execute(tasks);
        WaitPolicyTestCase.assertFalse((boolean)submitters.isEmpty());
        WaitPolicyTestCase.assertFalse((boolean)this.executor.awaitTermination(4000L, TimeUnit.MILLISECONDS));
        WaitPolicyTestCase.assertSame((Object)waiting, (Object)policy.lastRejectedRunnable());
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
    }

    public void testWaitPolicyWithTimeout() throws Exception {
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(2500L, TimeUnit.MILLISECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask waiting = new SleepyTask("waiting", 1000L);
        tasks.add(waiting);
        LinkedList<Thread> submitters = this.execute(tasks);
        WaitPolicyTestCase.assertFalse((boolean)submitters.isEmpty());
        WaitPolicyTestCase.assertFalse((boolean)this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS));
        WaitPolicyTestCase.assertSame((Object)waiting, (Object)policy.lastRejectedRunnable());
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
    }

    public void testWaitPolicyWithTimeoutFailure() throws Exception {
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
        long failureInterval = 100L;
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(failureInterval, TimeUnit.MILLISECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask failedTask = new SleepyTask("waitAndFail", 1000L);
        tasks.add(failedTask);
        LinkedList<Thread> submitters = this.execute(tasks);
        WaitPolicyTestCase.assertFalse((boolean)submitters.isEmpty());
        Thread.sleep(failureInterval * 10L);
        LinkedList<Map<Thread, Throwable>> exceptions = this.threadGroup.collectedExceptions();
        WaitPolicyTestCase.assertEquals((int)1, (int)exceptions.size());
        Map.Entry<Thread, Throwable> threadFailure = exceptions.getFirst().entrySet().iterator().next();
        WaitPolicyTestCase.assertEquals((Object)submitters.getLast(), (Object)threadFailure.getKey());
        WaitPolicyTestCase.assertEquals(RejectedExecutionException.class, threadFailure.getValue().getClass());
        this.executor.shutdown();
        WaitPolicyTestCase.assertTrue((boolean)this.executor.awaitTermination(2500L, TimeUnit.MILLISECONDS));
        WaitPolicyTestCase.assertSame((Object)failedTask, (Object)policy.lastRejectedRunnable());
        WaitPolicyTestCase.assertEquals((int)0, (int)SleepyTask.activeTasks.get());
    }
}

