/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Node;

public class JAXBUnmarshallerTransformer
extends AbstractTransformer {
    protected JAXBContext jaxbContext;

    public JAXBUnmarshallerTransformer() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(Writer.class));
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.registerSourceType(DataTypeFactory.create(URL.class));
        this.registerSourceType(DataTypeFactory.create(Node.class));
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.create(Source.class));
        this.registerSourceType(DataTypeFactory.create(XMLStreamReader.class));
        this.registerSourceType(DataTypeFactory.create(XMLEventReader.class));
    }

    public JAXBUnmarshallerTransformer(JAXBContext jaxbContext, DataType<?> returnType) {
        this();
        this.jaxbContext = jaxbContext;
        this.setReturnDataType(returnType);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.jaxbContext == null) {
            if (Object.class.equals((Object)this.getReturnDataType().getType())) {
                throw new InitialisationException(CoreMessages.objectIsNull((String)"jaxbContext"), (Initialisable)this);
            }
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.getReturnDataType().getType()});
            }
            catch (JAXBException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    protected Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            Unmarshaller u = this.jaxbContext.createUnmarshaller();
            if (src instanceof String) {
                return u.unmarshal((Reader)new StringReader((String)src));
            }
            if (src instanceof File) {
                return u.unmarshal((File)src);
            }
            if (src instanceof URL) {
                return u.unmarshal((URL)src);
            }
            if (src instanceof InputStream) {
                return u.unmarshal((InputStream)src);
            }
            if (src instanceof Node) {
                JAXBElement e = u.unmarshal((Node)src, this.getReturnDataType().getType());
                return e.getValue();
            }
            if (src instanceof Source) {
                JAXBElement e = u.unmarshal((Source)src, this.getReturnDataType().getType());
                return e.getValue();
            }
            if (src instanceof XMLStreamReader) {
                JAXBElement e = u.unmarshal((XMLStreamReader)src, this.getReturnDataType().getType());
                return e.getValue();
            }
            if (src instanceof XMLEventReader) {
                JAXBElement e = u.unmarshal((XMLEventReader)src, this.getReturnDataType().getType());
                return e.getValue();
            }
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return null;
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }
}

