/*
 * $Id: BindingExceptionOnInterfaceMethodTestCase.java 21860 2011-05-09 14:25:41Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.test.integration.routing.nested;

import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.FunctionalTestCase;
import org.mule.util.ExceptionUtils;

public class BindingExceptionOnInterfaceMethodTestCase extends FunctionalTestCase
{

    private static final String PREFIX = "Exception in service component: ";

    @Override
    protected String getConfigResources()
    {
        return "org/mule/test/integration/routing/nested/binding-exception-on-interface-method.xml";
    }
    
    public void testExceptionOnBinding() throws Exception
    {
        try
        {
            muleContext.getClient().send("vm://invoker.in", TEST_MESSAGE, null);
            fail("Exception expected");
        }
        catch (Exception e)
        {
            assertTrue(ExceptionUtils.getRootCause(e) instanceof MuleRuntimeException);
        }
    }

    public static class Component
    {
        private BindigInterface binding;
        
        public String invoke(String payload)
        {
            try
            {
                binding.process(payload, Integer.valueOf(0xC0DE));
            }
            catch (MuleRuntimeException muleException)
            {
                return PREFIX + muleException.toString();
            }
            
            return "ERROR, should not have come here";
        }

        public BindigInterface getBinding()
        {
            return binding;
        }

        public void setBinding(BindigInterface binding)
        {
            this.binding = binding;
        }
    }
    
    public static class ExceptionThrowingService
    {
        public String process(String s, Integer v)
        {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Boom"));
        }
    }
    
    public interface BindigInterface
    {
        String process(String s, Integer v) throws MuleRuntimeException;
    }

}


