/*
 * $Id: FtpStreamingTestCase.java 21939 2011-05-18 13:32:09Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.ftp;

import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalStreamingTestComponent;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class FtpStreamingTestCase extends AbstractFtpServerTestCase
{
    @Override
    protected String getConfigResources()
    {
        return "ftp-streaming-test.xml";
    }

    public void testRequest() throws Exception
    {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference messageHolder = new AtomicReference();

        EventCallback callback = new EventCallback()
        {
            public synchronized void eventReceived(MuleEventContext context, Object component)
            {
                try
                {
                    if (1 == latch.getCount())
                    {
                        messageHolder.set(context.getMessage());
                        latch.countDown();
                    }
                }
                catch (Exception e)
                {
                    fail();
                }
            }
        };

        Object component = getComponent("testComponent");
        assertTrue("FunctionalStreamingTestComponent expected", 
            component instanceof FunctionalStreamingTestComponent);
        FunctionalStreamingTestComponent ftc = (FunctionalStreamingTestComponent) component;
        ftc.setEventCallback(callback, TEST_MESSAGE.length());
       
        createFileOnFtpServer("input.txt");
               
        // poll and pull back through test service
        assertTrue(latch.await(getTimeout(), TimeUnit.MILLISECONDS));

        MuleMessage message = (MuleMessage) messageHolder.get();
        assertNotNull(message);
        assertTrue(message.getPayload() instanceof InputStream);
    }
}
