/*
 * $Id: NamedThreadFactoryTestCase.java 21939 2011-05-18 13:32:09Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.util.concurrent;

import org.mule.tck.AbstractMuleTestCase;

import java.util.concurrent.TimeUnit;

public class NamedThreadFactoryTestCase extends AbstractMuleTestCase
{

    protected Latch latch = new Latch();
    protected String testThreadName = "myThread";
    protected ClassLoader testClassLoader = new ClassLoader()
    {
    };
    protected Runnable nullRunnable = new Runnable()
    {
        public void run()
        {
        }
    };

    public void testNameContextClassloader() throws InterruptedException
    {
        NamedThreadFactory threadFactory = new NamedThreadFactory(testThreadName, testClassLoader);
        Thread t = threadFactory.newThread(new Runnable()
        {

            public void run()
            {
                assertEquals(testThreadName + ".01", Thread.currentThread().getName());
                assertEquals(testClassLoader, Thread.currentThread().getContextClassLoader());
                latch.countDown();
            }
        });
        t.start();
        assertTrue(latch.await(200, TimeUnit.MILLISECONDS));
    }

    public void testNameIncrement() throws InterruptedException
    {
        NamedThreadFactory threadFactory = new NamedThreadFactory(testThreadName);
        Thread t = threadFactory.newThread(nullRunnable);
        assertEquals(testThreadName + ".01", t.getName());
        t = threadFactory.newThread(nullRunnable);
        assertEquals(testThreadName + ".02", t.getName());
        t = threadFactory.newThread(nullRunnable);
        assertEquals(testThreadName + ".03", t.getName());
    }

}
