/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.MuleSession;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.component.BindingInvocationHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.RouterStatistics;
import org.mule.session.DefaultMuleSession;

public class CallInterfaceBinding
implements InterfaceBinding,
MessageProcessor {
    protected static final Log logger = LogFactory.getLog(CallInterfaceBinding.class);
    private Class<?> interfaceClass;
    private String methodName;
    protected OutboundEndpoint endpoint;
    private FlowConstruct flow;
    private RouterStatistics routerStatistics = new RouterStatistics(4);

    public CallInterfaceBinding(FlowConstruct flow) {
        this.flow = flow;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.endpoint.process(event);
    }

    public MuleMessage route(MuleMessage message, MuleSession session) throws MuleException {
        MuleEvent result;
        if (session == null) {
            session = new DefaultMuleSession(this.flow, message.getMuleContext());
        }
        if ((result = this.process((MuleEvent)new DefaultMuleEvent(message, this.endpoint.getExchangePattern(), session))) != null) {
            return result.getMessage();
        }
        return null;
    }

    public void setInterface(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public Class<?> getInterface() {
        return this.interfaceClass;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public Object createProxy(Object target) {
        try {
            Object proxy = Proxy.newProxyInstance(this.getInterface().getClassLoader(), new Class[]{this.getInterface()}, (InvocationHandler)new BindingInvocationHandler((InterfaceBinding)this));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Have proxy?: " + (null != proxy)));
            }
            return proxy;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreateProxyFor((Object)target), (Throwable)e);
        }
    }

    public void setEndpoint(ImmutableEndpoint e) {
        if (!(e instanceof OutboundEndpoint)) {
            throw new IllegalArgumentException("An outbound endpoint is required for Interface binding");
        }
        this.endpoint = (OutboundEndpoint)e;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DefaultInterfaceBinding");
        sb.append("{method='").append(this.methodName).append('\'');
        sb.append(", interface=").append(this.interfaceClass);
        sb.append('}');
        return sb.toString();
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }
}

