/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.ibeans.annotation.filter.AtomErrorFilter;
import org.ibeans.annotation.filter.ExpressionErrorFilter;
import org.ibeans.annotation.filter.JsonErrorFilter;
import org.ibeans.annotation.filter.RssErrorFilter;
import org.ibeans.annotation.filter.XmlErrorFilter;
import org.ibeans.api.IBeansException;
import org.ibeans.api.channel.MimeType;
import org.ibeans.spi.ErrorFilter;
import org.ibeans.spi.ErrorFilterFactory;
import org.mule.api.MuleContext;
import org.mule.module.ibeans.spi.ErrorExpressionFilter;
import org.mule.routing.filters.ExpressionFilter;

public class ExpressionErrorFilterFactory
implements ErrorFilterFactory {
    private MuleContext muleContext;

    public ExpressionErrorFilterFactory(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public boolean isSupported(Annotation annotation) {
        return annotation instanceof ExpressionErrorFilter || annotation instanceof XmlErrorFilter || annotation instanceof AtomErrorFilter || annotation instanceof RssErrorFilter || annotation instanceof JsonErrorFilter;
    }

    public ErrorFilterFactory.ErrorFilterHolder parse(Annotation anno) throws IBeansException {
        try {
            String evaluator;
            String expr = (String)anno.annotationType().getMethod("expr", new Class[0]).invoke((Object)anno, new Object[0]);
            String errorCode = (String)anno.annotationType().getMethod("errorCode", new Class[0]).invoke((Object)anno, new Object[0]);
            String tempMime = (String)anno.annotationType().getMethod("mimeType", new Class[0]).invoke((Object)anno, new Object[0]);
            MimeType mimeType = new MimeType(tempMime);
            try {
                Field f = anno.annotationType().getDeclaredField("eval");
                evaluator = (String)f.get(anno);
            }
            catch (NoSuchFieldException nsfe) {
                evaluator = (String)anno.annotationType().getMethod("eval", new Class[0]).invoke((Object)anno, new Object[0]);
            }
            if (evaluator.equals("xpath2") && !expr.startsWith("[boolean]")) {
                expr = "[boolean]" + expr;
            }
            ErrorExpressionFilter errorFilter = new ErrorExpressionFilter(evaluator, expr, errorCode);
            ((ExpressionFilter)errorFilter).setMuleContext(this.muleContext);
            return new ErrorFilterFactory.ErrorFilterHolder(mimeType, (ErrorFilter)errorFilter);
        }
        catch (Exception e) {
            throw new IBeansException("Failed to parse error filter from annotation: " + anno, (Throwable)e);
        }
    }
}

