/*
 * Decompiled with CFR 0.152.
 */
package org.mule.cache.keygenerator;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.cache.keygenerator.ExpressionKeyGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ExpressionKeyGeneratorTestCase
extends AbstractMuleTestCase {
    private static final String KEY = "KEY";
    private static final String EXPRESSION = "muleExpression";
    private ExpressionKeyGenerator keyGenerator;
    private MuleMessage message;
    private MuleEvent event;
    private ExpressionManager expressionManager;

    @Before
    public void setUp() throws Exception {
        this.expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)context.getExpressionManager()).thenReturn((Object)this.expressionManager);
        this.message = (MuleMessage)Mockito.mock(MuleMessage.class);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.event.getMuleContext()).thenReturn((Object)context);
        this.keyGenerator = new ExpressionKeyGenerator();
        this.keyGenerator.setExpression(EXPRESSION);
    }

    @Test
    public void testGeneratesSerializableKey() throws Exception {
        Mockito.when((Object)this.expressionManager.evaluate(EXPRESSION, this.message)).thenReturn((Object)KEY);
        Serializable key = this.keyGenerator.generateKey(this.event);
        Assert.assertEquals((Object)KEY, (Object)key);
    }

    @Test(expected=NotSerializableException.class)
    public void testThrowsExceptionOnNonSerializableKey() throws Exception {
        Mockito.when((Object)this.expressionManager.evaluate(EXPRESSION, this.message)).thenReturn(null);
        this.keyGenerator.generateKey(this.event);
    }
}

