/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.config.Preferred;
import org.mule.config.PreferredObjectSelector;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class PreferredObjectSelectorTestCase
extends AbstractMuleTestCase {
    @Test
    public void testSelectNoRegularClassIfThereIsNoPreferred() {
        ArrayList<NonPreferred> classes = new ArrayList<NonPreferred>();
        classes.add(new NonPreferred());
        PreferredObjectSelector selector = new PreferredObjectSelector();
        Object object = selector.select(classes.iterator());
        Assert.assertNotNull((String)"Selector selected a wrong object", (Object)(object instanceof NonPreferred));
    }

    @Test
    public void testSelectDefaultPreferredClassOverNoPreferredOne() {
        ArrayList<Object> classes = new ArrayList<Object>();
        classes.add(new NonPreferred());
        classes.add(new PreferredWithDefaultWeight());
        PreferredObjectSelector selector = new PreferredObjectSelector();
        Object object = selector.select(classes.iterator());
        Assert.assertNotNull((String)"Selector selected a wrong object", (Object)(object instanceof PreferredWithDefaultWeight));
    }

    @Test
    public void testSelectPreferredClassWithHighestWeight() {
        ArrayList<Object> classes = new ArrayList<Object>();
        classes.add(new NonPreferred());
        classes.add(new PreferredWithDefaultWeight());
        classes.add(new PreferredWithHighestWeight());
        PreferredObjectSelector selector = new PreferredObjectSelector();
        Object object = selector.select(classes.iterator());
        Assert.assertNotNull((String)"Selector selected a wrong object", (Object)(object instanceof PreferredWithHighestWeight));
    }

    @Preferred(weight=10)
    public class PreferredWithHighestWeight {
    }

    @Preferred
    public class PreferredWithDefaultWeight {
    }

    public class NonPreferred {
    }
}

