/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.outbound.OutboundResponsePropertiesMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class OutboundResponsePropertiesMessageProcessorTestCase
extends AbstractMessageProcessorTestCase {
    private static String MY_PROPERTY_KEY = "myProperty";
    private static String MY_PROPERTY_VAL = "myPropertyValue";
    private static String MULE_CORRELATION_ID_VAL = "152";

    @Test
    public void testProcess() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        OutboundResponsePropertiesMessageProcessor mp = new OutboundResponsePropertiesMessageProcessor(endpoint);
        mp.setListener(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                try {
                    return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(event.getMessage().getPayload(), muleContext), MessageExchangePattern.REQUEST_RESPONSE, AbstractMuleContextTestCase.getTestSession(AbstractMuleContextTestCase.getTestService(), muleContext));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        MuleEvent event = this.createTestOutboundEvent();
        event.getMessage().setOutboundProperty(MY_PROPERTY_KEY, (Object)MY_PROPERTY_VAL);
        event.getMessage().setOutboundProperty("MULE_CORRELATION_ID", (Object)MULE_CORRELATION_ID_VAL);
        MuleEvent result = mp.process(event);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Test Message", (Object)result.getMessageAsString());
        Assert.assertEquals((Object)MY_PROPERTY_VAL, (Object)result.getMessage().getOutboundProperty(MY_PROPERTY_KEY));
        Assert.assertEquals((Object)MULE_CORRELATION_ID_VAL, (Object)result.getMessage().getOutboundProperty("MULE_CORRELATION_ID"));
    }

    @Override
    protected void customizeEndpointBuilder(EndpointBuilder endpointBuilder) {
        endpointBuilder.setProperty((Object)"responseProperties", (Object)"myProperty");
    }
}

