/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.MessageHeaderExpressionEvaluator;
import org.mule.expression.MessageHeadersExpressionEvaluator;
import org.mule.expression.MessageHeadersListExpressionEvaluator;
import org.mule.routing.correlation.CorrelationPropertiesExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.UUID;

public class HeadersExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private Map<String, Object> props;

    @Override
    public void doSetUp() {
        this.props = new HashMap<String, Object>(3);
        this.props.put("foo", "foovalue");
        this.props.put("bar", "barvalue");
        this.props.put("baz", "bazvalue");
    }

    @Test
    public void testSingleHeader() throws Exception {
        MessageHeaderExpressionEvaluator eval = new MessageHeaderExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("foo", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
        result = eval.evaluate("foo?", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
        result = eval.evaluate("fool?", (MuleMessage)message);
        Assert.assertNull((Object)result);
        try {
            eval.evaluate("fool", (MuleMessage)message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        message.addInboundProperties(Collections.singletonMap("testProp", "value"));
        result = eval.evaluate("testProp?", (MuleMessage)message);
        Assert.assertNull((Object)result);
        result = eval.evaluate("INBOUND:testProp", (MuleMessage)message);
        Assert.assertEquals((Object)"value", (Object)result);
    }

    @Test
    public void testMapHeaders() throws Exception {
        MessageHeadersExpressionEvaluator eval = new MessageHeadersExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("foo, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("foo?, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("fool?", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        try {
            eval.evaluate("fool", (MuleMessage)message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        result = eval.evaluate("*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("barvalue"));
    }

    @Test
    public void testHeadersWithScopes() throws Exception {
        MessageHeadersExpressionEvaluator eval = new MessageHeadersExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setProperty("faz", (Object)"fazvalue", PropertyScope.INVOCATION);
        Object result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        result = eval.evaluate("OUTBOUND:foo, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz, INVOCATION:faz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("fazvalue"));
        result = eval.evaluate("OUTBOUND:foo, baz, INVOCATION:faz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("fazvalue"));
        try {
            eval.evaluate("OUTBOUND:foo, baz, faz", (MuleMessage)message);
            Assert.fail((String)"faz is not in outbound scope and is not optional");
        }
        catch (RequiredValueException e) {
            // empty catch block
        }
        result = eval.evaluate("OUTBOUND:foo, faz?, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        message.setInboundProperty("infoo", (Object)"infoovalue");
        result = eval.evaluate("infoo?", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = eval.evaluate("INBOUND:infoo?", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)1L, (long)((Map)result).size());
    }

    @Test
    public void testListHeaders() throws Exception {
        MessageHeadersListExpressionEvaluator eval = new MessageHeadersListExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("foo, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertFalse((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("foo?, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertFalse((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("fool?", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        try {
            eval.evaluate("fool", (MuleMessage)message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testListHeadersWithScopes() throws Exception {
        MessageHeadersListExpressionEvaluator eval = new MessageHeadersListExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setProperty("faz", (Object)"fazvalue", PropertyScope.INVOCATION);
        Object result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertFalse((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("OUTBOUND:foo, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        result = eval.evaluate("OUTBOUND:foo, OUTBOUND:baz, INVOCATION:faz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertTrue((boolean)((List)result).contains("fazvalue"));
        try {
            eval.evaluate("OUTBOUND:foo, baz, faz", (MuleMessage)message);
            Assert.fail((String)"faz is not in outbound scope and is not optional");
        }
        catch (RequiredValueException e) {
            // empty catch block
        }
        result = eval.evaluate("OUTBOUND:foo, faz?, baz", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
    }

    @Test
    public void testListHeadersWithWildcard() throws Exception {
        MessageHeadersListExpressionEvaluator eval = new MessageHeadersListExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertTrue((boolean)((List)result).contains("barvalue"));
        result = eval.evaluate("ba*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("barvalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        result = eval.evaluate("x*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = eval.evaluate("ba*, f*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertTrue((boolean)((List)result).contains("barvalue"));
    }

    @Test
    public void testMapHeadersWithWildcards() throws Exception {
        MessageHeadersExpressionEvaluator eval = new MessageHeadersExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("ba*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertFalse((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = eval.evaluate("x*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = eval.evaluate("ba*, f*", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("barvalue"));
    }

    @Test
    public void testSingleHeaderUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[header:foo]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[header:foo?]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[header:fool?]", (MuleMessage)message);
        Assert.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[header:fool]", (MuleMessage)message);
            Assert.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testMapHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers:foo, baz]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:foo?, baz]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertFalse((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:fool?]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[headers:fool]", (MuleMessage)message);
            Assert.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testMapHeadersWithWildcardsUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers:*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:ba*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertFalse((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers:x*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[headers:ba*, f*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("foovalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("bazvalue"));
        Assert.assertTrue((boolean)((Map)result).values().contains("barvalue"));
    }

    @Test
    public void testListHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:foo, baz]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertFalse((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:foo?, baz]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertFalse((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:fool?]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[headers-list:fool]", (MuleMessage)message);
            Assert.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testListHeadersWithWildCardsUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertTrue((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:ba*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertFalse((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertTrue((boolean)((List)result).contains("barvalue"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:x*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[headers-list:ba*, f*]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("foovalue"));
        Assert.assertTrue((boolean)((List)result).contains("bazvalue"));
        Assert.assertTrue((boolean)((List)result).contains("barvalue"));
    }

    @Test
    public void testCorrelationManagerCorrelationId() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        String correlationId = UUID.getUUID();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setCorrelationId(correlationId);
        Object result = evaluator.evaluate("MULE_CORRELATION_ID", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)correlationId, (Object)result);
    }

    @Test
    public void testCorrelationManagerNullResult() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        message.setUniqueId(null);
        try {
            evaluator.evaluate("MULE_CORRELATION_ID", (MuleMessage)message);
            Assert.fail((String)"Null result on CorrelationPropertiesExpressionEvaluator must throw");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCorrelationManagerUniqueId() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = evaluator.evaluate("MULE_MESSAGE_ID", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)message.getUniqueId(), (Object)result);
    }

    @Test
    public void testCorrelationManagerInvalidKey() {
        CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        try {
            evaluator.evaluate("invalid-key", (MuleMessage)message);
            Assert.fail((String)"invalid key on CorrelationPropertiesExpressionEvaluator must fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

