/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessagePropertiesContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessagePropertiesContextTestCase
extends AbstractMuleContextTestCase {
    @Override
    public void doTearDown() {
        RequestContext.clear();
    }

    @Test
    public void testPropertiesCase() throws Exception {
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("FOO", (Object)"BAR", PropertyScope.OUTBOUND);
        mpc.setProperty("ABC", (Object)"abc", PropertyScope.OUTBOUND);
        mpc.setProperty("DOO", (Object)"DAR", PropertyScope.INVOCATION);
        this.doTest(mpc);
    }

    @Test
    public void testSessionScope() throws Exception {
        MuleEvent e = MessagePropertiesContextTestCase.getTestEvent("testing");
        e.getSession().setProperty("SESSION_PROP", (Object)"Value1");
        RequestContext.setEvent((MuleEvent)e);
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        Assert.assertEquals((Object)"Value1", (Object)mpc.getProperty("SESSION_PROP", PropertyScope.SESSION));
        Assert.assertEquals((Object)"Value1", (Object)mpc.getProperty("SESSION_prop", PropertyScope.SESSION));
        Assert.assertNull((Object)mpc.getProperty("SESSION_X", PropertyScope.SESSION));
    }

    @Test
    public void testPropertyScopeOrder() throws Exception {
        MuleEvent e = MessagePropertiesContextTestCase.getTestEvent("testing");
        e.getSession().setProperty("Prop", (Object)"session");
        RequestContext.setEvent((MuleEvent)e);
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("Prop", (Object)"invocation", PropertyScope.INVOCATION);
        mpc.setProperty("Prop", (Object)"outbound", PropertyScope.OUTBOUND);
        Assert.assertEquals((Object)"outbound", (Object)mpc.getProperty("Prop", PropertyScope.OUTBOUND));
        mpc.removeProperty("Prop", PropertyScope.OUTBOUND);
        Assert.assertEquals((Object)"invocation", (Object)mpc.getProperty("Prop", PropertyScope.INVOCATION));
        mpc.removeProperty("Prop", PropertyScope.INVOCATION);
        Assert.assertEquals((Object)"session", (Object)mpc.getProperty("Prop", PropertyScope.SESSION));
        Assert.assertNull((Object)mpc.getProperty("Prop", PropertyScope.INBOUND));
        Assert.assertNull((Object)mpc.getProperty("Prop", PropertyScope.INVOCATION));
        Assert.assertNull((Object)mpc.getProperty("Prop", PropertyScope.OUTBOUND));
    }

    @Test
    public void testPropertiesCaseAfterSerialization() throws Exception {
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("FOO", (Object)"BAR", PropertyScope.OUTBOUND);
        mpc.setProperty("ABC", (Object)"abc", PropertyScope.OUTBOUND);
        mpc.setProperty("DOO", (Object)"DAR", PropertyScope.INVOCATION);
        this.doTest(mpc);
        byte[] bytes = SerializationUtils.serialize((Serializable)mpc);
        mpc = (MessagePropertiesContext)SerializationUtils.deserialize((byte[])bytes);
        this.doTest(mpc);
    }

    protected void doTest(MessagePropertiesContext mpc) {
        Assert.assertEquals((Object)"BAR", (Object)mpc.getProperty("foo", PropertyScope.OUTBOUND));
        Assert.assertEquals((Object)"DAR", (Object)mpc.getProperty("doo", PropertyScope.INVOCATION));
        Assert.assertEquals((Object)"abc", (Object)mpc.getProperty("abc", PropertyScope.OUTBOUND));
        Assert.assertEquals((Object)"BAR", (Object)mpc.getProperty("foO", PropertyScope.OUTBOUND));
        Assert.assertEquals((Object)"DAR", (Object)mpc.getProperty("doO", PropertyScope.INVOCATION));
        Assert.assertNull((Object)mpc.getProperty("doo", PropertyScope.INBOUND));
        Assert.assertNull((Object)mpc.getProperty("doo", PropertyScope.OUTBOUND));
        Assert.assertNull((Object)mpc.getProperty("doo", PropertyScope.SESSION));
        Set keys = mpc.getPropertyNames();
        Assert.assertEquals((long)3L, (long)keys.size());
        for (String key : keys) {
            Assert.assertTrue((key.equals("FOO") || key.equals("DOO") || key.equals("ABC") ? 1 : 0) != 0);
            Assert.assertFalse((key.equals("foo") || key.equals("doo") || key.equals("abc") ? 1 : 0) != 0);
        }
    }
}

