/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.beans.ExceptionListener;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.Transaction;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.concurrent.Latch;

public class AsyncInterceptingMessageProcessorTestCase
extends AbstractMuleContextTestCase
implements ExceptionListener {
    protected MessageProcessor messageProcessor;
    protected TestListener target = new TestListener();
    protected Exception exceptionThrown;
    protected Latch latch = new Latch();

    public AsyncInterceptingMessageProcessorTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.messageProcessor = this.createAsyncInterceptingMessageProcessor(this.target);
    }

    @Test
    public void testProcessOneWay() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        this.assertAsync(this.messageProcessor, event);
    }

    @Test
    public void testProcessRequestResponse() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestInboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE));
        try {
            this.messageProcessor.process(event);
            Assert.fail((String)"Exception expect: 'Unable to process a synchonrous event asyncronously'");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessOneWayWithTx() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestTransactedInboundEndpoint(MessageExchangePattern.ONE_WAY));
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            this.messageProcessor.process(event);
            Assert.fail((String)"Exception expect: 'Unable to process a synchonrous event asyncronously'");
        }
        catch (Exception exception) {
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessRequestResponseWithTx() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncInterceptingMessageProcessorTestCase.getTestTransactedInboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE));
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            this.messageProcessor.process(event);
            Assert.fail((String)"Exception expect: 'Unable to process a synchonrous event asyncronously'");
        }
        catch (Exception exception) {
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    protected void assertSync(MessageProcessor processor, MuleEvent event) throws MuleException {
        MuleEvent result = processor.process(event);
        Assert.assertSame((Object)event, (Object)this.target.sensedEvent);
        Assert.assertSame((Object)event, (Object)result);
        Assert.assertSame((Object)Thread.currentThread(), (Object)this.target.thread);
    }

    protected void assertAsync(MessageProcessor processor, MuleEvent event) throws MuleException, InterruptedException {
        MuleEvent result = processor.process(event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)this.target.sensedEvent);
        Assert.assertNotSame((Object)event, (Object)this.target.sensedEvent);
        Assert.assertEquals((Object)event.getMessageAsString(), (Object)this.target.sensedEvent.getMessageAsString());
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)this.target.thread);
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)this.exceptionThrown);
    }

    protected AsyncInterceptingMessageProcessor createAsyncInterceptingMessageProcessor(MessageProcessor listener) throws Exception {
        AsyncInterceptingMessageProcessor mp = new AsyncInterceptingMessageProcessor((WorkManagerSource)new TestWorkManagerSource());
        mp.setListener(listener);
        return mp;
    }

    @Override
    public void exceptionThrown(Exception e) {
        this.exceptionThrown = e;
    }

    class TestWorkManagerSource
    implements WorkManagerSource {
        TestWorkManagerSource() {
        }

        public WorkManager getWorkManager() throws MuleException {
            return muleContext.getWorkManager();
        }
    }

    class TestListener
    implements MessageProcessor {
        MuleEvent sensedEvent;
        Thread thread;

        TestListener() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.thread = Thread.currentThread();
            this.sensedEvent = event;
            AsyncInterceptingMessageProcessorTestCase.this.latch.countDown();
            return event;
        }
    }
}

