/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessagePropertyFilterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testMessagePropertyFilter() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterSessionScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        RequestContext.setEvent((MuleEvent)MessagePropertyFilterTestCase.getTestEvent(message));
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=bar");
        filter.setScope("session");
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setSessionProperty("foo", (Object)"bar");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterInboundScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        RequestContext.setEvent((MuleEvent)MessagePropertyFilterTestCase.getTestEvent(message));
        MessagePropertyFilter filter = new MessagePropertyFilter("inbound:foo=bar");
        Assert.assertEquals((Object)"inbound", (Object)filter.getScope());
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setInboundProperty("foo", (Object)"bar");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterWithURL() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        RequestContext.setEvent((MuleEvent)MessagePropertyFilterTestCase.getTestEvent(message));
        MessagePropertyFilter filter = new MessagePropertyFilter("inbound:foo=http://foo.com");
        Assert.assertEquals((Object)"inbound", (Object)filter.getScope());
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        HashMap<String, String> inboundProps = new HashMap<String, String>();
        inboundProps.put("foo", "http://foo.com");
        message = new DefaultMuleMessage((Object)"blah", inboundProps, null, null, muleContext);
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter = new MessagePropertyFilter("bar=http://bar.com");
        Assert.assertEquals((Object)"outbound", (Object)filter.getScope());
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("bar", (Object)"http://bar.com");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterWithNot() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"car");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterWithNotNull() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.removeProperty("foo");
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"car");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterWithCaseSensitivity() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=Bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        filter.setCaseSensitive(false);
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterWithWildcard() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=B*");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        filter.setCaseSensitive(false);
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter.setPattern("foo=*a*");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterDodgyValues() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter();
        Assert.assertFalse((boolean)filter.accept(null));
        filter = new MessagePropertyFilter("foo = bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter.setCaseSensitive(false);
        filter = new MessagePropertyFilter("foo2 =null");
        message.removeProperty("foo2");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter = new MessagePropertyFilter("foo2 =");
        message.setOutboundProperty("foo2", (Object)"");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        message.removeProperty("foo2");
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyFilterPropertyExists() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"car");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testMessagePropertyWithEnum() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=ONE_WAY");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Assert.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)MessageExchangePattern.ONE_WAY);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }
}

