/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.security.Credentials;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.management.stats.ProcessingTime;
import org.mule.tck.MuleTestUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.UUID;

public class OutboundRoutingTestEvent
implements MuleEvent {
    private MuleMessage message;
    private MuleSession session;
    private String id = UUID.getUUID();
    private boolean stopFurtherProcessing;
    int timeout = -1;
    private InboundEndpoint endpoint;

    public OutboundRoutingTestEvent(MuleMessage message, MuleSession session, MuleContext muleContext) throws Exception {
        this.message = message;
        this.session = session;
        this.endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public MuleMessage getMessage() {
        return this.message;
    }

    public MuleSession getSession() {
        return this.session;
    }

    public Credentials getCredentials() {
        return null;
    }

    public byte[] getMessageAsBytes() throws MuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public String getMessageAsString() throws MuleException {
        try {
            return this.message.getPayloadAsString();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public String getMessageAsString(String encoding) throws MuleException {
        try {
            return this.message.getPayloadAsString(encoding);
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public Object transformMessage() throws TransformerException {
        throw new UnsupportedOperationException();
    }

    public <T> T transformMessage(Class<T> outputType) throws TransformerException {
        return this.transformMessage(DataTypeFactory.create(outputType));
    }

    public <T> T transformMessage(DataType<T> outputType) throws TransformerException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public byte[] transformMessageToBytes() throws TransformerException {
        return (byte[])this.transformMessage(DataType.BYTE_ARRAY_DATA_TYPE);
    }

    public String transformMessageToString() throws TransformerException {
        try {
            return new String(this.transformMessageToBytes(), this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return "Unsupported Encoding";
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getProperty(String name) {
        return null;
    }

    public Object getProperty(String name, Object defaultValue) {
        return defaultValue;
    }

    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public String getEncoding() {
        return this.message.getEncoding();
    }

    public MuleContext getMuleContext() {
        return null;
    }

    public FlowConstruct getFlowConstruct() {
        try {
            return this.session == null ? MuleTestUtils.getTestService(this.message.getMuleContext()) : this.session.getFlowConstruct();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ProcessingTime getProcessingTime() {
        return null;
    }

    public MessageExchangePattern getExchangePattern() {
        return this.endpoint.getExchangePattern();
    }

    public boolean isTransacted() {
        return false;
    }

    public URI getMessageSourceURI() {
        return URI.create("test://test");
    }

    public String getMessageSourceName() {
        return "test";
    }

    public ReplyToHandler getReplyToHandler() {
        return null;
    }

    public Object getReplyToDestination() {
        return null;
    }

    public void captureReplyToDestination() {
    }

    public boolean isSynchronous() {
        return false;
    }
}

