/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.compression;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.compression.CompressionHelper;
import org.mule.util.compression.CompressionStrategy;

public class CompressionTestCase
extends AbstractMuleTestCase {
    @Test
    public void testCompressDefaultGZip() throws Exception {
        String temp = "This is a compressed string";
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        byte[] compressed = strategy.compressByteArray(temp.getBytes());
        Assert.assertTrue((compressed.length > temp.getBytes().length ? 1 : 0) != 0);
        byte[] uncompressed = strategy.uncompressByteArray(compressed);
        Assert.assertTrue((uncompressed.length == temp.getBytes().length ? 1 : 0) != 0);
        Assert.assertEquals((Object)temp, (Object)new String(uncompressed));
        String tempLarge = temp;
        for (int i = 0; i < 100; ++i) {
            tempLarge = tempLarge + temp;
        }
        compressed = strategy.compressByteArray(tempLarge.getBytes());
        Assert.assertTrue((compressed.length < tempLarge.getBytes().length ? 1 : 0) != 0);
        uncompressed = strategy.uncompressByteArray(compressed);
        Assert.assertTrue((uncompressed.length == tempLarge.getBytes().length ? 1 : 0) != 0);
        Assert.assertEquals((Object)tempLarge, (Object)new String(uncompressed));
    }

    @Test
    public void testNullIsCompressed() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        Assert.assertFalse((boolean)strategy.isCompressed(null));
    }

    @Test
    public void testEmptyIsCompressed() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        Assert.assertFalse((boolean)strategy.isCompressed(new byte[0]));
    }

    @Test
    public void testCompressNullBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        Assert.assertNull((Object)strategy.compressByteArray(null));
    }

    @Test
    public void testCompressEmptyBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        byte[] bytes = new byte[]{};
        byte[] result = strategy.compressByteArray(bytes);
        Assert.assertTrue((boolean)strategy.isCompressed(result));
    }

    @Test
    public void testUncompressNullBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        Assert.assertNull((Object)strategy.uncompressByteArray(null));
    }

    @Test
    public void testUncompressEmptyBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        byte[] bytes = new byte[]{};
        byte[] cmpbytes = strategy.compressByteArray(bytes);
        Assert.assertTrue((boolean)strategy.isCompressed(cmpbytes));
        byte[] result = strategy.uncompressByteArray(cmpbytes);
        Assert.assertTrue((boolean)Arrays.equals(bytes, result));
    }
}

