/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.mule.api.registry.RegistrationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.store.MuleObjectStoreManager;
import org.mule.util.store.ObjectStorePartition;
import org.mule.util.store.PartitionedInMemoryObjectStore;
import org.mule.util.store.PartitionedObjectStoreWrapper;
import org.mule.util.store.PartitionedPersistentObjectStore;
import org.mule.util.store.QueuePersistenceObjectStore;
import org.mule.util.store.SimpleMemoryObjectStore;

public class ManagedStoresTestCase
extends AbstractMuleTestCase {
    public ManagedStoresTestCase() {
        this.setDisposeManagerPerSuite(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        MuleObjectStoreManager manager = (MuleObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        manager.clearStoreCache();
    }

    public void testInMemoryStore() throws ObjectStoreException, InterruptedException, RegistrationException {
        muleContext.getRegistry().registerObject("_defaultInMemoryQueueStore", (Object)new SimpleMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("inMemoryPart1", false);
        ManagedStoresTestCase.assertTrue((boolean)(store instanceof PartitionedObjectStoreWrapper));
        ListableObjectStore baseStore = ((PartitionedObjectStoreWrapper)store).getBaseStore();
        ManagedStoresTestCase.assertTrue((boolean)(baseStore instanceof SimpleMemoryObjectStore));
        ManagedStoresTestCase.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore"));
        this.testObjectStore(store);
        this.testObjectStoreExpiry(manager.getObjectStore("inMemoryExpPart1", false, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("inMemoryMaxPart1", false, 10, 10000, 200));
    }

    public void testPersistentStore() throws ObjectStoreException, InterruptedException, RegistrationException {
        QueuePersistenceObjectStore queueStore = new QueuePersistenceObjectStore(muleContext);
        queueStore.open();
        muleContext.getRegistry().registerObject("_defaultPersistentQueueStore", (Object)queueStore);
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("persistencePart1", true);
        ManagedStoresTestCase.assertTrue((boolean)(store instanceof PartitionedObjectStoreWrapper));
        ListableObjectStore baseStore = ((PartitionedObjectStoreWrapper)store).getBaseStore();
        ManagedStoresTestCase.assertTrue((boolean)(baseStore instanceof QueuePersistenceObjectStore));
        ManagedStoresTestCase.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultPersistentQueueStore"));
        this.testObjectStore(store, false);
        this.testObjectStoreExpiry(manager.getObjectStore("persistenceExpPart1", true, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("persistenceMaxPart1", true, 10, 10000, 200));
    }

    public void testPartitionableInMemoryStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        muleContext.getRegistry().registerObject("_defaultInMemoryQueueStore", (Object)new PartitionedInMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("inMemoryPart2", false);
        ManagedStoresTestCase.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        ManagedStoresTestCase.assertTrue((boolean)(baseStore instanceof PartitionedInMemoryObjectStore));
        ManagedStoresTestCase.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore"));
        this.testObjectStore(store);
        this.testObjectStoreExpiry(manager.getObjectStore("inMemoryExpPart2", false, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("inMemoryMaxPart2", false, 10, 10000, 200));
    }

    public void testPartitionablePersistenceStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        PartitionedPersistentObjectStore partitionedStore = new PartitionedPersistentObjectStore(muleContext);
        partitionedStore.open();
        muleContext.getRegistry().registerObject("_defaultPersistentQueueStore", (Object)partitionedStore);
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("persistencePart2", true);
        ManagedStoresTestCase.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        ManagedStoresTestCase.assertTrue((boolean)(baseStore instanceof PartitionedPersistentObjectStore));
        ManagedStoresTestCase.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultPersistentQueueStore"));
        this.testObjectStore(store);
        this.testObjectStoreExpiry(manager.getObjectStore("persistenceExpPart2", true, -1, 1000, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("persistenceMaxPart2", true, 10, 10000, 200));
    }

    private void testObjectStore(ListableObjectStore store) throws ObjectStoreException {
        this.testObjectStore(store, true);
    }

    private void testObjectStore(ListableObjectStore store, boolean removeReturnsObject) throws ObjectStoreException {
        Throwable e = null;
        store.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        ManagedStoresTestCase.assertEquals((Object)"value1", (Object)store.retrieve((Serializable)((Object)"key1")));
        ManagedStoresTestCase.assertTrue((boolean)store.contains((Serializable)((Object)"key1")));
        try {
            store.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        }
        catch (ObjectAlreadyExistsException e1) {
            e = e1;
        }
        ManagedStoresTestCase.assertNotNull((Object)e);
        e = null;
        ManagedStoresTestCase.assertEquals((int)1, (int)store.allKeys().size());
        ManagedStoresTestCase.assertEquals((Object)"key1", store.allKeys().get(0));
        if (removeReturnsObject) {
            ManagedStoresTestCase.assertEquals((Object)"value1", (Object)store.remove((Serializable)((Object)"key1")));
        } else {
            ManagedStoresTestCase.assertNull((Object)store.remove((Serializable)((Object)"key1")));
        }
        ManagedStoresTestCase.assertFalse((boolean)store.contains((Serializable)((Object)"key1")));
        try {
            store.retrieve((Serializable)((Object)"key1"));
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        ManagedStoresTestCase.assertNotNull((Object)e);
        e = null;
        try {
            store.remove((Serializable)((Object)"key1"));
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        ManagedStoresTestCase.assertNotNull((Object)e);
        e = null;
    }

    private void testObjectStoreExpiry(ObjectStore objectStore) throws ObjectStoreException, InterruptedException {
        objectStore.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        ManagedStoresTestCase.assertEquals((Object)"value1", (Object)objectStore.retrieve((Serializable)((Object)"key1")));
        Thread.sleep(2000L);
        ManagedStoresTestCase.assertFalse((String)"Object with key1 still exists.", (boolean)objectStore.contains((Serializable)((Object)"key1")));
    }

    private void testObjectStoreMaxEntries(ListableObjectStore objectStore) throws ObjectStoreException, InterruptedException {
        int i;
        for (i = 0; i < 100; ++i) {
            objectStore.store((Serializable)((Object)("key" + i)), (Serializable)((Object)("value" + i)));
            ManagedStoresTestCase.assertEquals((Object)("value" + i), (Object)objectStore.retrieve((Serializable)((Object)("key" + i))));
        }
        Thread.sleep(2000L);
        ManagedStoresTestCase.assertEquals((int)10, (int)objectStore.allKeys().size());
        for (i = 90; i < 100; ++i) {
            ManagedStoresTestCase.assertTrue((String)("Checking that key" + i + " exists"), (boolean)objectStore.contains((Serializable)((Object)("key" + i))));
        }
    }
}

