/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.tangosol;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.provider.AbstractCacheModelValidator;
import org.springmodules.cache.provider.InvalidCacheModelException;
import org.springmodules.cache.provider.tangosol.CoherenceCachingModel;
import org.springmodules.cache.provider.tangosol.CoherenceFlushingModel;

public class CoherenceModelValidator
extends AbstractCacheModelValidator {
    protected Class getCachingModelTargetClass() {
        return CoherenceCachingModel.class;
    }

    protected Class getFlushingModelTargetClass() {
        return CoherenceFlushingModel.class;
    }

    protected void validateCachingModelProperties(Object cachingModel) throws InvalidCacheModelException {
        CoherenceCachingModel model = (CoherenceCachingModel)cachingModel;
        if (!StringUtils.hasText((String)model.getCacheName())) {
            throw new InvalidCacheModelException("Cache name should not be empty");
        }
    }

    protected void validateFlushingModelProperties(Object flushingModel) throws InvalidCacheModelException {
        CoherenceFlushingModel model = (CoherenceFlushingModel)flushingModel;
        Object[] cacheNames = model.getCacheNames();
        if (ObjectUtils.isEmpty((Object[])cacheNames)) {
            throw new InvalidCacheModelException("There should be at least one cache name");
        }
    }
}

