/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.processor.FlowConstructStatisticsMessageProcessor;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.processor.StopFurtherMessageProcessingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChain;

public abstract class AbstractConfigurationPattern
extends AbstractPipeline {
    protected final List<MessageProcessor> transformers;
    protected final List<MessageProcessor> responseTransformers;

    public AbstractConfigurationPattern(String name, MuleContext muleContext, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers) {
        super(name, muleContext);
        Validate.notNull(transformers, (String)"transformers can't be null");
        Validate.notNull(responseTransformers, (String)"transformers can't be null");
        this.transformers = transformers;
        this.responseTransformers = responseTransformers;
    }

    @Override
    protected final void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        this.configureMessageProcessorsBeforeTransformation(builder);
        builder.chain(DefaultMessageProcessorChain.from(this.transformers));
        builder.chain(new ResponseMessageProcessorAdapter(DefaultMessageProcessorChain.from(this.responseTransformers)));
        builder.chain(new StopFurtherMessageProcessingMessageProcessor());
        this.configureMessageProcessorsAfterTransformation(builder);
    }

    @Override
    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        super.configurePreProcessors(builder);
        builder.chain(new ProcessIfStartedMessageProcessor(this, this.getLifecycleState()));
        builder.chain(new ProcessingTimeInterceptor());
        builder.chain(new FlowConstructStatisticsMessageProcessor());
    }

    public boolean hasTransformers() {
        return !this.transformers.isEmpty();
    }

    public boolean hasResponseTransformers() {
        return !this.responseTransformers.isEmpty();
    }

    @Override
    public final void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        throw new UnsupportedOperationException();
    }

    protected abstract void configureMessageProcessorsBeforeTransformation(MessageProcessorChainBuilder var1) throws MuleException;

    protected abstract void configureMessageProcessorsAfterTransformation(MessageProcessorChainBuilder var1) throws MuleException;
}

